/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.reader;

import java.math.BigDecimal;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemRecoverer;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.sample.domain.Trade;

public class GeneratingItemReader
implements ItemReader,
ItemRecoverer {
    private int limit = 1;
    private int counter = 0;
    private int marked;

    public Object read() throws Exception {
        if (this.counter < this.limit) {
            ++this.counter;
            return new Trade("isin" + this.counter, this.counter, new BigDecimal(this.counter), "customer" + this.counter);
        }
        return null;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getCounter() {
        return this.counter;
    }

    public int getLimit() {
        return this.limit;
    }

    public Object recover(Object data, Throwable cause) {
        return data;
    }

    public void mark() throws MarkFailedException {
        this.marked = this.counter;
    }

    public void reset() throws ResetFailedException {
        this.counter = this.marked;
    }
}

