/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.dao;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.dao.CustomerCreditDao;
import org.springframework.batch.sample.domain.CustomerCredit;
import org.springframework.beans.factory.DisposableBean;

public class FlatFileCustomerCreditDao
implements CustomerCreditDao,
DisposableBean {
    private ItemWriter itemWriter;
    private String separator = "\t";
    private volatile boolean opened = false;

    public void writeCredit(CustomerCredit customerCredit) throws Exception {
        if (!this.opened) {
            this.open(new ExecutionContext());
        }
        String line = "" + customerCredit.getName() + this.separator + customerCredit.getCredit();
        this.itemWriter.write((Object)line);
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setItemWriter(ItemWriter itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void open(ExecutionContext executionContext) throws Exception {
        if (this.itemWriter instanceof ItemStream) {
            ((ItemStream)this.itemWriter).open(executionContext);
        }
        this.opened = true;
    }

    public void close() throws Exception {
        if (this.itemWriter instanceof ItemStream) {
            ((ItemStream)this.itemWriter).close(null);
        }
    }

    public void destroy() throws Exception {
        this.close();
    }
}

