/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.springframework.batch.item.file.mapping.DefaultFieldSet;
import org.springframework.batch.item.file.mapping.FieldSet;

public final class FieldSetResultSetExtractor {
    private FieldSetResultSetExtractor() {
    }

    public static FieldSet getFieldSet(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        DefaultFieldSet fs = null;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 1; i <= columnCount; ++i) {
            tokens.add(rs.getString(i));
            names.add(metaData.getColumnName(i));
        }
        fs = new DefaultFieldSet(tokens.toArray(new String[0]), names.toArray(new String[0]));
        return fs;
    }
}

