/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;

public class MessageSourcePollerInterceptor
implements ChannelInterceptor,
InitializingBean {
    private static final Log logger = LogFactory.getLog(MessageSourcePollerInterceptor.class);
    private MessageSource<?> source;
    private @Nullable MessageChannel channel;

    public MessageSourcePollerInterceptor(MessageSource<?> source) {
        this.source = source;
    }

    public void setChannel(MessageChannel channel) {
        this.channel = channel;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.source != null ? 1 : 0) != 0, (String)"A MessageSource must be provided");
    }

    public void setMessageSource(MessageSource<?> source) {
        this.source = source;
    }

    public boolean preReceive(MessageChannel channel) {
        Message message = this.source.receive();
        if (message != null) {
            if (this.channel != null) {
                channel = this.channel;
            }
            channel.send(message);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sent " + String.valueOf(message) + " to channel " + String.valueOf(channel)));
            }
            return true;
        }
        return true;
    }
}

