/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.job.JobInterruptedException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.Step;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class StepExecutionRequestHandler {
    private JobRepository jobRepository;
    private StepLocator stepLocator;

    public void setStepLocator(StepLocator stepLocator) {
        this.stepLocator = stepLocator;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @ServiceActivator
    public StepExecution handle(StepExecutionRequest request) {
        Long stepExecutionId;
        Long jobExecutionId = request.getJobExecutionId();
        StepExecution stepExecution = this.jobRepository.getStepExecution(jobExecutionId, stepExecutionId = request.getStepExecutionId());
        if (stepExecution == null) {
            throw new NoSuchStepException("No StepExecution could be located for this request: " + String.valueOf(request));
        }
        String stepName = request.getStepName();
        Step step = this.stepLocator.getStep(stepName);
        if (step == null) {
            throw new NoSuchStepException(String.format("No Step with name [%s] could be located.", stepName));
        }
        try {
            step.execute(stepExecution);
        }
        catch (JobInterruptedException e) {
            stepExecution.setStatus(BatchStatus.STOPPED);
        }
        catch (Throwable e) {
            stepExecution.addFailureException(e);
            stepExecution.setStatus(BatchStatus.FAILED);
        }
        return stepExecution;
    }
}

