/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class StepExecutionRequestHandler {
    private JobExplorer jobExplorer;
    private StepLocator stepLocator;

    public void setStepLocator(StepLocator stepLocator) {
        this.stepLocator = stepLocator;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    @ServiceActivator
    public StepExecution handle(StepExecutionRequest request) {
        Long stepExecutionId;
        Long jobExecutionId = request.getJobExecutionId();
        StepExecution stepExecution = this.jobExplorer.getStepExecution(jobExecutionId, stepExecutionId = request.getStepExecutionId());
        if (stepExecution == null) {
            throw new IllegalStateException("No StepExecution could be located for this request: " + request);
        }
        String stepName = request.getStepName();
        Step step = this.stepLocator.getStep(stepName);
        if (step == null) {
            throw new IllegalStateException(String.format("No Step with name [%s] could be located.", stepName));
        }
        try {
            step.execute(stepExecution);
        }
        catch (JobInterruptedException e) {
            stepExecution.setStatus(BatchStatus.STOPPED);
        }
        catch (Throwable e) {
            stepExecution.addFailureException(e);
            stepExecution.setStatus(BatchStatus.FAILED);
        }
        return stepExecution;
    }
}

