/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.xml.StaxEventItemReader;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.GenericMessage;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToMessagesJobFactoryBean<T>
implements FactoryBean,
BeanNameAware {
    private String name = "fileToMessageJob";
    private ItemReader<? extends T> itemReader;
    private MessageChannel channel;
    private PlatformTransactionManager transactionManager;
    private JobRepository jobRepository;

    public void setBeanName(String name) {
        this.name = name;
    }

    @Required
    public void setItemReader(ItemReader<? extends T> itemReader) {
        this.itemReader = itemReader;
    }

    @Required
    public void setChannel(MessageChannel channel) {
        this.channel = channel;
    }

    @Required
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Required
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Object getObject() throws Exception {
        SimpleJob job = new SimpleJob();
        job.setName(this.name);
        job.setJobRepository(this.jobRepository);
        SimpleStepFactoryBean stepFactory = new SimpleStepFactoryBean();
        stepFactory.setBeanName("step");
        Assert.state((this.itemReader instanceof FlatFileItemReader || this.itemReader instanceof StaxEventItemReader ? 1 : 0) != 0, (String)"ItemReader must be either a FlatFileItemReader or a StaxEventItemReader");
        JobParameterResourceProxy resourceProxy = new JobParameterResourceProxy();
        resourceProxy.setKey("input.file.path");
        stepFactory.setListeners((StepListener[])new StepExecutionListener[]{resourceProxy});
        this.setResource(this.itemReader, resourceProxy);
        stepFactory.setItemReader(this.itemReader);
        Assert.notNull((Object)this.channel, (String)"A channel must be provided");
        Assert.state((boolean)(this.channel instanceof DirectChannel), (String)"The channel must be a DirectChannel (otherwise failures can not be recovered from)");
        MessageChannelItemWriter itemWriter = new MessageChannelItemWriter(this.channel);
        stepFactory.setItemWriter(itemWriter);
        Assert.notNull((Object)this.transactionManager, (String)"A transaction manager must be provided");
        stepFactory.setTransactionManager(this.transactionManager);
        Assert.notNull((Object)this.jobRepository, (String)"A job repository must be provided");
        stepFactory.setJobRepository(this.jobRepository);
        job.addStep((Step)stepFactory.getObject());
        return job;
    }

    private void setResource(ItemReader<? extends T> itemReader, Resource resource) {
        if (itemReader instanceof FlatFileItemReader) {
            ((FlatFileItemReader)itemReader).setResource(resource);
        } else {
            ((StaxEventItemReader)itemReader).setResource(resource);
        }
    }

    public Class<Job> getObjectType() {
        return Job.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageChannelItemWriter<T>
    implements ItemWriter<T> {
        private MessageChannel channel;

        public MessageChannelItemWriter(MessageChannel channel) {
            this.channel = channel;
        }

        public void write(List<? extends T> items) throws Exception {
            for (T item : items) {
                this.channel.send((Message)new GenericMessage(item));
            }
        }
    }

    private class JobParameterResourceProxy
    extends StepExecutionListenerSupport
    implements Resource,
    ResourceLoaderAware,
    StepExecutionListener {
        private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
        private ResourceLoader resourceLoader = new FileSystemResourceLoader();
        private Resource delegate;
        private String key = null;
        private static final String NOT_INITIALISED = "The delegate resource has not been initialised. Remember to register this object as a StepListener.";

        private JobParameterResourceProxy() {
        }

        public Resource createRelative(String relativePath) throws IOException {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.createRelative(relativePath);
        }

        public boolean exists() {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.exists();
        }

        public String getDescription() {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.getDescription();
        }

        public File getFile() throws IOException {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.getFile();
        }

        public String getFilename() {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.getFilename();
        }

        public InputStream getInputStream() throws IOException {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.getInputStream();
        }

        public URI getURI() throws IOException {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.getURI();
        }

        public URL getURL() throws IOException {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.getURL();
        }

        public boolean isOpen() {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.isOpen();
        }

        public boolean isReadable() {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.isReadable();
        }

        public long lastModified() throws IOException {
            Assert.state((this.delegate != null ? 1 : 0) != 0, (String)NOT_INITIALISED);
            return this.delegate.lastModified();
        }

        public void setJobParametersFactory(JobParametersConverter jobParametersConverter) {
            this.jobParametersConverter = jobParametersConverter;
        }

        public boolean isSingleton() {
            return false;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void beforeStep(StepExecution execution) {
            Properties properties = this.jobParametersConverter.getProperties(execution.getJobExecution().getJobInstance().getJobParameters());
            this.delegate = this.resourceLoader.getResource(properties.getProperty(this.key));
        }
    }
}

