/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStream;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.ItemStreamWriter;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeItemWriter<T>
implements ItemStreamWriter<T>,
InitializingBean {
    private List<ItemWriter<? super T>> delegates;
    private boolean ignoreItemStream = false;

    public CompositeItemWriter(List<ItemWriter<? super T>> delegates) {
        this.delegates = delegates;
    }

    @SafeVarargs
    public CompositeItemWriter(ItemWriter<? super T> ... delegates) {
        this(Arrays.asList(delegates));
    }

    public void setIgnoreItemStream(boolean ignoreItemStream) {
        this.ignoreItemStream = ignoreItemStream;
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        for (ItemWriter<? extends T> itemWriter : this.delegates) {
            itemWriter.write(chunk);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((!this.delegates.isEmpty() ? 1 : 0) != 0, (String)"The 'delegates' may not be empty");
    }

    public void setDelegates(List<ItemWriter<? super T>> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void close() throws ItemStreamException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ItemWriter<? super T> itemWriter : this.delegates) {
            if (this.ignoreItemStream || !(itemWriter instanceof ItemStream)) continue;
            ItemStream itemStream = (ItemStream)((Object)itemWriter);
            try {
                itemStream.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            String message = String.format("Failed to close %d delegate(s) due to exceptions", exceptions.size());
            ItemStreamException itemStreamException = new ItemStreamException(message);
            exceptions.forEach(itemStreamException::addSuppressed);
            throw itemStreamException;
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemWriter<? super T> itemWriter : this.delegates) {
            if (this.ignoreItemStream || !(itemWriter instanceof ItemStream)) continue;
            ItemStream itemStream = (ItemStream)((Object)itemWriter);
            itemStream.open(executionContext);
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemWriter<? super T> itemWriter : this.delegates) {
            if (this.ignoreItemStream || !(itemWriter instanceof ItemStream)) continue;
            ItemStream itemStream = (ItemStream)((Object)itemWriter);
            itemStream.update(executionContext);
        }
    }
}

