/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.queue.builder;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.batch.item.queue.BlockingQueueItemReader;
import org.springframework.util.Assert;

public class BlockingQueueItemReaderBuilder<T> {
    private BlockingQueue<T> queue;
    private long timeout = 1L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    public BlockingQueueItemReaderBuilder<T> queue(BlockingQueue<T> queue) {
        this.queue = queue;
        return this;
    }

    public BlockingQueueItemReaderBuilder<T> timeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        return this;
    }

    public BlockingQueueItemReader<T> build() {
        Assert.state((this.queue != null ? 1 : 0) != 0, (String)"The blocking queue is required.");
        BlockingQueueItemReader<T> blockingQueueItemReader = new BlockingQueueItemReader<T>(this.queue);
        blockingQueueItemReader.setTimeout(this.timeout, this.timeUnit);
        return blockingQueueItemReader;
    }
}

