/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.StringUtils;

public class RepositoryItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(RepositoryItemWriter.class);
    private CrudRepository<T, ?> repository;
    private String methodName;

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setRepository(CrudRepository<T, ?> repository) {
        this.repository = repository;
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        if (!CollectionUtils.isEmpty(chunk.getItems())) {
            this.doWrite(chunk);
        }
    }

    protected void doWrite(Chunk<? extends T> items) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing to the repository with " + items.size() + " items."));
        }
        if (this.methodName == null) {
            this.repository.saveAll(items);
            return;
        }
        MethodInvoker invoker = this.createMethodInvoker(this.repository, this.methodName);
        for (Object object : items) {
            invoker.setArguments(new Object[]{object});
            this.doInvoke(invoker);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.repository != null ? 1 : 0) != 0, (String)"A CrudRepository implementation is required");
        if (this.methodName != null) {
            Assert.state((boolean)StringUtils.hasText((String)this.methodName), (String)"methodName must not be empty.");
        } else {
            logger.debug((Object)"No method name provided, CrudRepository.saveAll will be used.");
        }
    }

    private Object doInvoke(MethodInvoker invoker) throws Exception {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return invoker.invoke();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new AbstractMethodInvokingDelegator.InvocationTargetThrowableWrapper(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        return invoker;
    }
}

