/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.batch.item.SkipWrapper;

public class Chunk<W>
implements Iterable<W>,
Serializable {
    private List<W> items = new ArrayList<W>();
    private List<SkipWrapper<W>> skips = new ArrayList<SkipWrapper<W>>();
    private final List<Exception> errors = new ArrayList<Exception>();
    private Object userData;
    private boolean end;
    private boolean busy;

    @SafeVarargs
    public Chunk(W ... items) {
        this(Arrays.asList(items));
    }

    @SafeVarargs
    public static <W> Chunk<W> of(W ... items) {
        return new Chunk<W>(items);
    }

    public Chunk(List<? extends W> items) {
        this(items, null);
    }

    public Chunk(List<? extends W> items, List<SkipWrapper<W>> skips) {
        if (items != null) {
            this.items = new ArrayList<W>(items);
        }
        if (skips != null) {
            this.skips = new ArrayList<SkipWrapper<W>>(skips);
        }
    }

    public void add(W item) {
        this.items.add(item);
    }

    public void addAll(List<W> items) {
        this.items.addAll(items);
    }

    public void clear() {
        this.items.clear();
        this.skips.clear();
        this.userData = null;
    }

    public List<W> getItems() {
        return Collections.unmodifiableList(new ArrayList<W>(this.items));
    }

    public List<SkipWrapper<W>> getSkips() {
        return Collections.unmodifiableList(this.skips);
    }

    public List<Exception> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void skip(Exception e) {
        this.errors.add(e);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ChunkIterator iterator() {
        return new ChunkIterator(this.items);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd() {
        this.end = true;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public void clearSkips() {
        this.skips.clear();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public String toString() {
        return String.format("[items=%s, skips=%s]", this.items, this.skips);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)obj;
        return Objects.equals(this.items, other.items) && Objects.equals(this.skips, other.skips) && Objects.equals(this.errors, other.errors) && Objects.equals(this.userData, other.userData) && this.end == other.end && this.busy == other.busy;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.items.hashCode();
        result = 31 * result + this.skips.hashCode();
        result = 31 * result + this.errors.hashCode();
        result = 31 * result + Objects.hashCode(this.userData);
        result = 31 * result + (this.end ? 1 : 0);
        result = 31 * result + (this.busy ? 1 : 0);
        return result;
    }

    public class ChunkIterator
    implements Iterator<W> {
        private final Iterator<W> iterator;
        private W next;

        public ChunkIterator(List<W> items) {
            this.iterator = items.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public W next() {
            this.next = this.iterator.next();
            return this.next;
        }

        public void remove(Throwable e) {
            this.remove();
            Chunk.this.skips.add(new SkipWrapper(this.next, e));
        }

        @Override
        public void remove() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else {
                    return;
                }
            }
            this.iterator.remove();
        }

        public String toString() {
            return String.format("[items=%s, skips=%s]", Chunk.this.items, Chunk.this.skips);
        }
    }
}

