/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.json;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.json.JsonObjectReader;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GsonJsonObjectReader<T>
implements JsonObjectReader<T> {
    private Class<? extends T> itemType;
    private JsonReader jsonReader;
    private Gson mapper = new Gson();
    private InputStream inputStream;

    public GsonJsonObjectReader(Class<? extends T> itemType) {
        this.itemType = itemType;
    }

    public void setMapper(Gson mapper) {
        Assert.notNull((Object)mapper, (String)"The mapper must not be null");
        this.mapper = mapper;
    }

    @Override
    public void open(Resource resource) throws Exception {
        Assert.notNull((Object)resource, (String)"The resource must not be null");
        this.inputStream = resource.getInputStream();
        this.jsonReader = this.mapper.newJsonReader((Reader)new InputStreamReader(this.inputStream));
        Assert.state((this.jsonReader.peek() == JsonToken.BEGIN_ARRAY ? 1 : 0) != 0, (String)"The Json input stream must start with an array of Json objects");
        this.jsonReader.beginArray();
    }

    @Override
    @Nullable
    public T read() throws Exception {
        try {
            if (this.jsonReader.hasNext()) {
                return (T)this.mapper.fromJson(this.jsonReader, this.itemType);
            }
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            throw new ParseException("Unable to read next JSON object", e);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.inputStream.close();
        this.jsonReader.close();
    }
}

