/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.builder;

import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FlatFileItemWriterBuilder<T> {
    private Resource resource;
    private boolean forceSync = false;
    private String lineSeparator = FlatFileItemWriter.DEFAULT_LINE_SEPARATOR;
    private LineAggregator<T> lineAggregator;
    private String encoding = "UTF-8";
    private boolean shouldDeleteIfExists = true;
    private boolean append = false;
    private boolean shouldDeleteIfEmpty = false;
    private FlatFileHeaderCallback headerCallback;
    private FlatFileFooterCallback footerCallback;
    private boolean transactional = true;
    private boolean saveState = true;
    private String name;

    public FlatFileItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public FlatFileItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public FlatFileItemWriterBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public FlatFileItemWriterBuilder<T> forceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public FlatFileItemWriterBuilder<T> lineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public FlatFileItemWriterBuilder<T> lineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
        return this;
    }

    public FlatFileItemWriterBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public FlatFileItemWriterBuilder<T> shouldDeleteIfEmpty(boolean shouldDelete) {
        this.shouldDeleteIfEmpty = shouldDelete;
        return this;
    }

    public FlatFileItemWriterBuilder<T> shouldDeleteIfExists(boolean shouldDelete) {
        this.shouldDeleteIfExists = shouldDelete;
        return this;
    }

    public FlatFileItemWriterBuilder<T> append(boolean append) {
        this.append = append;
        return this;
    }

    public FlatFileItemWriterBuilder<T> headerCallback(FlatFileHeaderCallback callback) {
        this.headerCallback = callback;
        return this;
    }

    public FlatFileItemWriterBuilder<T> footerCallback(FlatFileFooterCallback callback) {
        this.footerCallback = callback;
        return this;
    }

    public FlatFileItemWriterBuilder<T> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public FlatFileItemWriter<T> build() {
        Assert.notNull(this.lineAggregator, (String)"A LineAggregator is required");
        Assert.notNull((Object)this.resource, (String)"A Resource is required");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is true");
        }
        FlatFileItemWriter<T> writer = new FlatFileItemWriter<T>();
        writer.setName(this.name);
        writer.setAppendAllowed(this.append);
        writer.setEncoding(this.encoding);
        writer.setFooterCallback(this.footerCallback);
        writer.setForceSync(this.forceSync);
        writer.setHeaderCallback(this.headerCallback);
        writer.setLineAggregator(this.lineAggregator);
        writer.setLineSeparator(this.lineSeparator);
        writer.setResource(this.resource);
        writer.setSaveState(this.saveState);
        writer.setShouldDeleteIfEmpty(this.shouldDeleteIfEmpty);
        writer.setShouldDeleteIfExists(this.shouldDeleteIfExists);
        writer.setTransactional(this.transactional);
        return writer;
    }
}

