/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class Neo4jItemReader<T>
extends AbstractPaginatedDataItemReader<T>
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Neo4jOperations template;
    private String startStatement;
    private String returnStatement;
    private String matchStatement;
    private String whereStatement;
    private String orderByStatement;
    private Class targetType;
    private Map<String, Object> parameterValues;
    private ResultConverter resultConverter;

    public Neo4jItemReader() {
        this.setName(ClassUtils.getShortName(Neo4jItemReader.class));
    }

    public void setStartStatement(String startStatement) {
        this.startStatement = startStatement;
    }

    public void setReturnStatement(String returnStatement) {
        this.returnStatement = returnStatement;
    }

    public void setMatchStatement(String matchStatement) {
        this.matchStatement = matchStatement;
    }

    public void setWhereStatement(String whereStatement) {
        this.whereStatement = whereStatement;
    }

    public void setOrderByStatement(String orderByStatement) {
        this.orderByStatement = orderByStatement;
    }

    public void setTemplate(Neo4jOperations template) {
        this.template = template;
    }

    public void setTargetType(Class targetType) {
        this.targetType = targetType;
    }

    public void setResultConverter(ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    @Override
    protected Iterator<T> doPageRead() {
        Result queryResults = this.template.query(this.generateLimitCypherQuery(), this.parameterValues);
        if (queryResults != null) {
            if (this.resultConverter != null) {
                return queryResults.to(this.targetType, this.resultConverter).iterator();
            }
            return queryResults.to(this.targetType).iterator();
        }
        return new ArrayList().iterator();
    }

    private String generateLimitCypherQuery() {
        StringBuilder query = new StringBuilder();
        query.append("START ").append(this.startStatement);
        query.append(this.matchStatement != null ? " MATCH " + this.matchStatement : "");
        query.append(this.whereStatement != null ? " WHERE " + this.whereStatement : "");
        query.append(" RETURN ").append(this.returnStatement);
        query.append(" ORDER BY ").append(this.orderByStatement);
        query.append(" SKIP " + this.pageSize * this.page);
        query.append(" LIMIT " + this.pageSize);
        String resultingQuery = query.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)resultingQuery);
        }
        return resultingQuery;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.template != null ? 1 : 0) != 0, (String)"A Neo4JOperations implementation is required");
        Assert.state((this.targetType != null ? 1 : 0) != 0, (String)"The type to be returned is required");
        Assert.state((boolean)StringUtils.hasText((String)this.startStatement), (String)"A START statement is required");
        Assert.state((boolean)StringUtils.hasText((String)this.returnStatement), (String)"A RETURN statement is required");
        Assert.state((boolean)StringUtils.hasText((String)this.orderByStatement), (String)"A ORDER BY statement is required");
    }
}

