/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.mail;

import org.springframework.batch.item.mail.MailErrorHandler;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSendException;

public class DefaultMailErrorHandler
implements MailErrorHandler {
    private static final int DEFAULT_MAX_MESSAGE_LENGTH = 1024;
    private int maxMessageLength = 1024;

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    @Override
    public void handle(MailMessage message, Exception exception) throws MailException {
        String msg = message.toString();
        throw new MailSendException("Mail server send failed: " + msg.substring(0, Math.min(this.maxMessageLength, msg.length())), (Throwable)exception);
    }
}

