/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DelimitedLineTokenizer
extends AbstractLineTokenizer {
    public static final String DELIMITER_TAB = "\t";
    public static final String DELIMITER_COMMA = ",";
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    private String delimiter;
    private char quoteCharacter = (char)34;
    private String quoteString;
    private Collection<Integer> includedFields = null;

    public DelimitedLineTokenizer() {
        this(DELIMITER_COMMA);
    }

    public DelimitedLineTokenizer(String delimiter) {
        Assert.state((!delimiter.equals(String.valueOf('\"')) ? 1 : 0) != 0, (String)"[\"] is not allowed as delimiter for tokenizers.");
        this.delimiter = delimiter;
        this.setQuoteCharacter('\"');
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setIncludedFields(int[] includedFields) {
        this.includedFields = new HashSet<Integer>();
        for (int i : includedFields) {
            this.includedFields.add(i);
        }
    }

    public final void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
        this.quoteString = "" + quoteCharacter;
    }

    @Override
    protected List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        char[] chars = line.toCharArray();
        boolean inQuoted = false;
        int lastCut = 0;
        int length = chars.length;
        int fieldCount = 0;
        int endIndexLastDelimiter = -1;
        for (int i = 0; i < length; ++i) {
            char currentChar = chars[i];
            boolean isEnd = i == length - 1;
            boolean isDelimiter = this.isDelimiter(chars, i, this.delimiter, endIndexLastDelimiter);
            if (isDelimiter && !inQuoted || isEnd) {
                int endPosition;
                endIndexLastDelimiter = i;
                int n = endPosition = isEnd ? length - lastCut : i - lastCut;
                if (isEnd && isDelimiter) {
                    endPosition -= this.delimiter.length();
                } else if (!isEnd) {
                    endPosition = endPosition - this.delimiter.length() + 1;
                }
                if (this.includedFields == null || this.includedFields.contains(fieldCount)) {
                    String value = this.maybeStripQuotes(new String(chars, lastCut, endPosition));
                    tokens.add(value);
                }
                ++fieldCount;
                if (isEnd && isDelimiter) {
                    if (this.includedFields == null || this.includedFields.contains(fieldCount)) {
                        tokens.add("");
                    }
                    ++fieldCount;
                }
                lastCut = i + 1;
                continue;
            }
            if (!this.isQuoteCharacter(currentChar)) continue;
            inQuoted = !inQuoted;
        }
        return tokens;
    }

    private String maybeStripQuotes(String string) {
        String value = string.trim();
        if (this.isQuoted(value)) {
            int endLength = (value = StringUtils.replace((String)value, (String)("" + this.quoteCharacter + this.quoteCharacter), (String)("" + this.quoteCharacter))).length() - 1;
            if (endLength == 0) {
                endLength = 1;
            }
            value = value.substring(1, endLength);
            return value;
        }
        return string;
    }

    private boolean isQuoted(String value) {
        return value.startsWith(this.quoteString) && value.endsWith(this.quoteString);
    }

    private boolean isDelimiter(char[] chars, int i, String token, int endIndexLastDelimiter) {
        String end;
        boolean result = false;
        if (i - endIndexLastDelimiter >= this.delimiter.length() && i >= token.length() - 1 && token.equals(end = new String(chars, i - token.length() + 1, token.length()))) {
            result = true;
        }
        return result;
    }

    protected boolean isQuoteCharacter(char c) {
        return c == this.quoteCharacter;
    }
}

