/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiResourceItemReader<T>
implements ItemReader<T>,
ItemStream {
    private static final Log logger = LogFactory.getLog(MultiResourceItemReader.class);
    private static final String RESOURCE_KEY = "resourceIndex";
    private final ExecutionContextUserSupport executionContextUserSupport = new ExecutionContextUserSupport();
    private ResourceAwareItemReaderItemStream<? extends T> delegate;
    private Resource[] resources;
    private boolean saveState = true;
    private int currentResource = -1;
    private boolean noInput;
    private boolean strict = false;
    private Comparator<Resource> comparator = new Comparator<Resource>(){

        @Override
        public int compare(Resource r1, Resource r2) {
            return r1.getFilename().compareTo(r2.getFilename());
        }
    };

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public MultiResourceItemReader() {
        this.executionContextUserSupport.setName(ClassUtils.getShortName(MultiResourceItemReader.class));
    }

    @Override
    public T read() throws Exception, UnexpectedInputException, ParseException {
        if (this.noInput) {
            return null;
        }
        if (this.currentResource == -1) {
            this.currentResource = 0;
            this.delegate.setResource(this.resources[this.currentResource]);
            this.delegate.open(new ExecutionContext());
        }
        return this.readNextItem();
    }

    private T readNextItem() throws Exception {
        Object item = this.delegate.read();
        while (item == null) {
            ++this.currentResource;
            if (this.currentResource >= this.resources.length) {
                return null;
            }
            this.delegate.close();
            this.delegate.setResource(this.resources[this.currentResource]);
            this.delegate.open(new ExecutionContext());
            item = this.delegate.read();
        }
        return item;
    }

    @Override
    public void close() throws ItemStreamException {
        this.delegate.close();
        this.noInput = false;
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        Assert.notNull((Object)this.resources, (String)"Resources must be set");
        this.noInput = false;
        if (this.resources.length == 0) {
            if (this.strict) {
                throw new IllegalStateException("No resources to read. Set strict=false if this is not an error condition.");
            }
            logger.warn((Object)"No resources to read. Set strict=true if this should be an error condition.");
            this.noInput = true;
            return;
        }
        Arrays.sort(this.resources, this.comparator);
        if (executionContext.containsKey(this.executionContextUserSupport.getKey(RESOURCE_KEY))) {
            this.currentResource = executionContext.getInt(this.executionContextUserSupport.getKey(RESOURCE_KEY));
            if (this.currentResource == -1) {
                this.currentResource = 0;
            }
            this.delegate.setResource(this.resources[this.currentResource]);
            this.delegate.open(executionContext);
        } else {
            this.currentResource = -1;
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            executionContext.putInt(this.executionContextUserSupport.getKey(RESOURCE_KEY), this.currentResource);
            this.delegate.update(executionContext);
        }
    }

    public void setDelegate(ResourceAwareItemReaderItemStream<? extends T> delegate) {
        this.delegate = delegate;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void setComparator(Comparator<Resource> comparator) {
        this.comparator = comparator;
    }

    public void setResources(Resource[] resources) {
        Assert.notNull((Object)resources, (String)"The resources must not be null");
        this.resources = Arrays.asList(resources).toArray(new Resource[resources.length]);
    }

    public Resource getCurrentResource() {
        if (this.currentResource >= this.resources.length || this.currentResource < 0) {
            return null;
        }
        return this.resources[this.currentResource];
    }
}

