/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.DefaultResultCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatTemplate
implements RepeatOperations {
    protected Log logger = LogFactory.getLog(this.getClass());
    private RepeatListener[] listeners = new RepeatListener[0];
    private CompletionPolicy completionPolicy = new DefaultResultCompletionPolicy();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = Arrays.asList(listeners).toArray(new RepeatListener[listeners.length]);
    }

    public void registerListener(RepeatListener listener) {
        ArrayList<RepeatListener> list = new ArrayList<RepeatListener>(Arrays.asList(this.listeners));
        list.add(listener);
        this.listeners = list.toArray(new RepeatListener[list.size()]);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setCompletionPolicy(CompletionPolicy terminationPolicy) {
        Assert.notNull((Object)terminationPolicy);
        this.completionPolicy = terminationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepeatStatus iterate(RepeatCallback callback) {
        RepeatContext outer = RepeatSynchronizationManager.getContext();
        RepeatStatus result = RepeatStatus.CONTINUABLE;
        try {
            result = this.executeInternal(callback);
        }
        finally {
            RepeatSynchronizationManager.clear();
            if (outer != null) {
                RepeatSynchronizationManager.register(outer);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RepeatStatus executeInternal(RepeatCallback callback) {
        Object v1;
        RepeatStatus result;
        RepeatContext context;
        block22: {
            context = this.start();
            boolean running = !this.isMarkedComplete(context);
            for (int i = 0; i < this.listeners.length; ++i) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.open(context);
                boolean bl = running = running && !this.isMarkedComplete(context);
                if (!running) break;
            }
            result = RepeatStatus.CONTINUABLE;
            RepeatInternalState state = this.createInternalState(context);
            Collection<Throwable> throwables = state.getThrowables();
            ArrayList<Throwable> deferred = new ArrayList<Throwable>();
            while (running) {
                for (int i = 0; i < this.listeners.length; ++i) {
                    RepeatListener interceptor = this.listeners[i];
                    interceptor.before(context);
                    running = running && !this.isMarkedComplete(context);
                }
                if (!running) continue;
                try {
                    result = this.getNextResult(context, callback, state);
                    this.executeAfterInterceptors(context, result);
                }
                catch (Throwable throwable) {
                    this.doHandle(throwable, context, deferred);
                }
                if (!this.isComplete(context, result) && !this.isMarkedComplete(context) && deferred.isEmpty()) continue;
                running = false;
            }
            result = result.and(this.waitForResults(state));
            for (Throwable throwable : throwables) {
                this.doHandle(throwable, context, deferred);
            }
            state = null;
            Object var11_13 = null;
            if (!deferred.isEmpty()) {
                Throwable throwable3 = (Throwable)deferred.iterator().next();
                this.logger.debug((Object)("Handling fatal exception explicitly (rethrowing first of " + deferred.size() + "): " + throwable3.getClass().getName() + ": " + throwable3.getMessage()));
                RepeatTemplate.rethrow(throwable3);
            }
            Object var14_17 = null;
            try {
                int i = this.listeners.length;
                while (i-- > 0) {
                    RepeatListener interceptor = this.listeners[i];
                    interceptor.close(context);
                }
                v1 = null;
                break block22;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
                break block22;
            }
            catch (Throwable throwable) {
                Object v2;
                Object var14_18 = null;
                try {
                    int i = this.listeners.length;
                    while (i-- > 0) {
                        RepeatListener interceptor = this.listeners[i];
                        interceptor.close(context);
                    }
                    v2 = null;
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var18_34 = v2;
                context.close();
                throw throwable;
            }
            catch (Throwable throwable) {
                Object v3;
                block24: {
                    Object var11_14 = null;
                    if (!deferred.isEmpty()) {
                        Throwable throwable3 = (Throwable)deferred.iterator().next();
                        this.logger.debug((Object)("Handling fatal exception explicitly (rethrowing first of " + deferred.size() + "): " + throwable3.getClass().getName() + ": " + throwable3.getMessage()));
                        RepeatTemplate.rethrow(throwable3);
                    }
                    Object var14_19 = null;
                    try {
                        int i = this.listeners.length;
                        while (i-- > 0) {
                            RepeatListener interceptor = this.listeners[i];
                            interceptor.close(context);
                        }
                        v3 = null;
                        break block24;
                    }
                    catch (Throwable throwable4) {
                        v3 = null;
                    }
                    {
                    }
                    catch (Throwable throwable5) {
                        Object v4;
                        Object var14_20 = null;
                        try {
                            int i = this.listeners.length;
                            while (i-- > 0) {
                                RepeatListener interceptor = this.listeners[i];
                                interceptor.close(context);
                            }
                            v4 = null;
                        }
                        catch (Throwable throwable6) {
                            v4 = null;
                        }
                        Object var18_36 = v4;
                        context.close();
                        throw throwable5;
                    }
                }
                Object var18_35 = v3;
                context.close();
                throw throwable;
            }
        }
        Object var18_33 = v1;
        context.close();
        return result;
    }

    private void doHandle(Throwable throwable, RepeatContext context, Collection<Throwable> deferred) {
        Throwable unwrappedThrowable = RepeatTemplate.unwrapIfRethrown(throwable);
        try {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                this.logger.debug((Object)("Exception intercepted (" + (i + 1) + " of " + this.listeners.length + ")"), unwrappedThrowable);
                interceptor.onError(context, unwrappedThrowable);
            }
            this.logger.debug((Object)("Handling exception: " + throwable.getClass().getName() + ", caused by: " + unwrappedThrowable.getClass().getName() + ": " + unwrappedThrowable.getMessage()));
            this.exceptionHandler.handleException(context, unwrappedThrowable);
        }
        catch (Throwable handled) {
            deferred.add(handled);
        }
    }

    private static void rethrow(Throwable throwable) throws RuntimeException {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RepeatException("Exception in batch process", throwable);
    }

    private static Throwable unwrapIfRethrown(Throwable throwable) {
        if (throwable instanceof RepeatException) {
            return throwable.getCause();
        }
        return throwable;
    }

    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new RepeatInternalStateSupport();
    }

    protected RepeatStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        this.update(context);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Repeat operation about to start at count=" + context.getStartedCount()));
        }
        return callback.doInIteration(context);
    }

    protected boolean waitForResults(RepeatInternalState state) {
        return true;
    }

    protected final boolean canContinue(RepeatStatus value) {
        return value.isContinuable();
    }

    private boolean isMarkedComplete(RepeatContext context) {
        boolean complete = context.isCompleteOnly();
        if (context.getParent() != null) {
            boolean bl = complete = complete || this.isMarkedComplete(context.getParent());
        }
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to context alone.");
        }
        return complete;
    }

    protected void executeAfterInterceptors(RepeatContext context, RepeatStatus value) {
        if (value != null && value.isContinuable()) {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.after(context, value);
            }
        }
    }

    protected boolean isComplete(RepeatContext context, RepeatStatus result) {
        boolean complete = this.completionPolicy.isComplete(context, result);
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to policy and result value.");
        }
        return complete;
    }

    protected boolean isComplete(RepeatContext context) {
        boolean complete = this.completionPolicy.isComplete(context);
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to policy alone not including result.");
        }
        return complete;
    }

    protected RepeatContext start() {
        RepeatContext parent = RepeatSynchronizationManager.getContext();
        RepeatContext context = this.completionPolicy.start(parent);
        RepeatSynchronizationManager.register(context);
        this.logger.debug((Object)"Starting repeat context.");
        return context;
    }

    protected void update(RepeatContext context) {
        this.completionPolicy.update(context);
    }
}

