/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.classify;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.batch.classify.Classifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubclassClassifier<T, C>
implements Classifier<T, C> {
    private Map<Class<? extends T>, C> classified = new HashMap<Class<? extends T>, C>();
    private C defaultValue = null;

    public SubclassClassifier() {
        this(null);
    }

    public SubclassClassifier(C defaultValue) {
        this(new HashMap(), defaultValue);
    }

    public SubclassClassifier(Map<Class<? extends T>, C> typeMap, C defaultValue) {
        this.classified = new HashMap<Class<T>, C>(typeMap);
        this.defaultValue = defaultValue;
    }

    public void setDefaultValue(C defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTypeMap(Map<Class<? extends T>, C> map) {
        this.classified = new HashMap<Class<T>, C>(map);
    }

    @Override
    public C classify(T classifiable) {
        if (classifiable == null) {
            return this.defaultValue;
        }
        Class<?> exceptionClass = classifiable.getClass();
        if (this.classified.containsKey(exceptionClass)) {
            return this.classified.get(exceptionClass);
        }
        TreeSet<Class<? extends T>> classes = new TreeSet<Class<? extends T>>(new ClassComparator());
        classes.addAll(this.classified.keySet());
        for (Class clazz : classes) {
            if (!clazz.isAssignableFrom(exceptionClass)) continue;
            C value = this.classified.get(clazz);
            this.classified.put(exceptionClass, value);
            return value;
        }
        return this.defaultValue;
    }

    public final C getDefault() {
        return this.defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> arg0, Class<?> arg1) {
            if (arg0.isAssignableFrom(arg1)) {
                return 1;
            }
            return -1;
        }
    }
}

