/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.classify.ClassifierSupport;
import org.springframework.batch.item.ItemWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierCompositeItemWriter<T>
implements ItemWriter<T> {
    private Classifier<T, ItemWriter<? super T>> classifier = new ClassifierSupport<T, Object>(null);

    public void setClassifier(Classifier<T, ItemWriter<? super T>> classifier) {
        this.classifier = classifier;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        HashMap map = new HashMap();
        for (T item : items) {
            ItemWriter<? super T> key = this.classifier.classify(item);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(item);
        }
        for (ItemWriter writer : map.keySet()) {
            writer.write((List)map.get(writer));
        }
    }
}

