/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcParameterUtils {
    public static int countParameterPlaceholders(String sql, List<String> namedParameterHolder) {
        if (sql == null) {
            return 0;
        }
        char[] statement = sql.toCharArray();
        boolean withinQuotes = false;
        HashMap<String, StringBuilder> namedParameters = new HashMap<String, StringBuilder>();
        int currentQuote = 45;
        int parameterCount = 0;
        int i = 0;
        while (i < statement.length) {
            if (withinQuotes) {
                if (statement[i] == currentQuote) {
                    withinQuotes = false;
                    currentQuote = 45;
                }
            } else if (statement[i] == '\"' || statement[i] == '\'') {
                withinQuotes = true;
                currentQuote = statement[i];
            } else if (statement[i] == ':' || statement[i] == '&') {
                int j = i + 1;
                StringBuilder parameter = new StringBuilder();
                while (j < statement.length && JdbcParameterUtils.parameterNameContinues(statement, j)) {
                    parameter.append(statement[j]);
                    ++j;
                }
                if (j - i > 1 && !namedParameters.containsKey(parameter.toString())) {
                    ++parameterCount;
                    namedParameters.put(parameter.toString(), parameter);
                    i = j - 1;
                }
            } else if (statement[i] == '?') {
                ++parameterCount;
            }
            ++i;
        }
        if (namedParameterHolder != null) {
            namedParameterHolder.addAll(namedParameters.keySet());
        }
        return parameterCount;
    }

    private static boolean parameterNameContinues(char[] statement, int pos) {
        return statement[pos] != ' ' && statement[pos] != ',' && statement[pos] != ')' && statement[pos] != '\"' && statement[pos] != '\'' && statement[pos] != '|' && statement[pos] != ';' && statement[pos] != '\n' && statement[pos] != '\r';
    }
}

