/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.io.IOException;
import java.io.Writer;
import org.springframework.batch.support.transaction.FlushFailedException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareBufferedWriter
extends Writer {
    private static final String BUFFER_KEY_PREFIX = TransactionAwareBufferedWriter.class.getName() + ".BUFFER_KEY";
    private final String bufferKey;
    private Writer writer;

    public TransactionAwareBufferedWriter(Writer writer, String name) {
        this.writer = writer;
        this.bufferKey = BUFFER_KEY_PREFIX + "." + name;
    }

    private StringBuffer getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.bufferKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.bufferKey, (Object)new StringBuffer());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    StringBuffer buffer = (StringBuffer)TransactionSynchronizationManager.getResource((Object)TransactionAwareBufferedWriter.this.bufferKey);
                    if (status == 0) {
                        try {
                            TransactionAwareBufferedWriter.this.writer.write(buffer.toString());
                            TransactionAwareBufferedWriter.this.writer.flush();
                        }
                        catch (IOException e) {
                            throw new FlushFailedException("Could not write to output buffer", e);
                        }
                    }
                    TransactionSynchronizationManager.unbindResource((Object)TransactionAwareBufferedWriter.this.bufferKey);
                }
            });
        }
        return (StringBuffer)TransactionSynchronizationManager.getResource((Object)this.bufferKey);
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        if (!this.transactionActive()) {
            this.writer.flush();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.transactionActive()) {
            this.writer.write(cbuf, off, len);
            return;
        }
        StringBuffer buffer = this.getCurrentBuffer();
        buffer.append(cbuf, off, len);
    }
}

