/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.batch.item.util.FileUtils;
import org.springframework.batch.item.xml.StaxWriterCallback;
import org.springframework.batch.item.xml.stax.NoStartEndDocumentStreamWriter;
import org.springframework.batch.support.transaction.TransactionAwareBufferedWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.transform.StaxResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxEventItemWriter<T>
extends ExecutionContextUserSupport
implements ResourceAwareItemWriterItemStream<T>,
InitializingBean {
    private static final Log log = LogFactory.getLog(StaxEventItemWriter.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private static final String DEFAULT_ROOT_TAG_NAME = "root";
    private static final String RESTART_DATA_NAME = "position";
    private static final String WRITE_STATISTICS_NAME = "record.count";
    private Resource resource;
    private Marshaller marshaller;
    private String encoding = "UTF-8";
    private String version = "1.0";
    private String rootTagName = "root";
    private Map<String, String> rootElementAttributes = null;
    private boolean overwriteOutput = true;
    private FileChannel channel;
    private XMLEventWriter eventWriter;
    private XMLEventWriter delegateEventWriter;
    private long currentRecordCount = 0L;
    private boolean saveState = true;
    private StaxWriterCallback headerCallback;
    private StaxWriterCallback footerCallback;

    public StaxEventItemWriter() {
        this.setName(ClassUtils.getShortName(StaxEventItemWriter.class));
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setHeaderCallback(StaxWriterCallback headerCallback) {
        this.headerCallback = headerCallback;
    }

    public void setFooterCallback(StaxWriterCallback footerCallback) {
        this.footerCallback = footerCallback;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRootTagName() {
        return this.rootTagName;
    }

    public void setRootTagName(String rootTagName) {
        this.rootTagName = rootTagName;
    }

    public Map<String, String> getRootElementAttributes() {
        return this.rootElementAttributes;
    }

    public void setRootElementAttributes(Map<String, String> rootElementAttributes) {
        this.rootElementAttributes = rootElementAttributes;
    }

    public void setOverwriteOutput(boolean overwriteOutput) {
        this.overwriteOutput = overwriteOutput;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.marshaller);
    }

    @Override
    public void open(ExecutionContext executionContext) {
        Assert.notNull((Object)this.resource, (String)"The resource must be set");
        long startAtPosition = 0L;
        boolean restarted = false;
        if (executionContext.containsKey(this.getKey(RESTART_DATA_NAME))) {
            startAtPosition = executionContext.getLong(this.getKey(RESTART_DATA_NAME));
            restarted = true;
        }
        this.open(startAtPosition, restarted);
        if (startAtPosition == 0L) {
            try {
                if (this.headerCallback != null) {
                    this.headerCallback.write(this.delegateEventWriter);
                }
            }
            catch (IOException e) {
                throw new ItemStreamException("Failed to write headerItems", e);
            }
        }
    }

    private void open(long position, boolean restarted) {
        FileOutputStream os = null;
        try {
            File file = this.resource.getFile();
            FileUtils.setUpOutputFile(file, restarted, this.overwriteOutput);
            Assert.state((boolean)this.resource.exists(), (String)"Output resource must exist");
            os = new FileOutputStream(file, true);
            this.channel = os.getChannel();
            this.setPosition(position);
        }
        catch (IOException ioe) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)ioe);
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            this.delegateEventWriter = outputFactory.createXMLEventWriter(new TransactionAwareBufferedWriter(new OutputStreamWriter((OutputStream)os, this.encoding), this.getName()));
            this.eventWriter = new NoStartEndDocumentStreamWriter(this.delegateEventWriter);
            if (!restarted) {
                this.startDocument(this.delegateEventWriter);
            }
        }
        catch (XMLStreamException xse) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)xse);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "] with encoding=[" + this.encoding + "]", (Throwable)e);
        }
    }

    protected void startDocument(XMLEventWriter writer) throws XMLStreamException {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        writer.add(factory.createStartDocument(this.getEncoding(), this.getVersion()));
        writer.add(factory.createStartElement("", "", this.getRootTagName()));
        if (!CollectionUtils.isEmpty(this.getRootElementAttributes())) {
            for (Map.Entry<String, String> entry : this.getRootElementAttributes().entrySet()) {
                writer.add(factory.createAttribute(entry.getKey(), entry.getValue()));
            }
        }
        writer.flush();
    }

    protected void endDocument(XMLEventWriter writer) throws XMLStreamException {
        ByteBuffer bbuf = ByteBuffer.wrap(("</" + this.getRootTagName() + ">").getBytes());
        try {
            this.channel.write(bbuf);
        }
        catch (IOException ioe) {
            throw new DataAccessResourceFailureException("Unable to close file resource: [" + this.resource + "]", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        try {
            this.delegateEventWriter.add(factory.createCharacters(""));
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
        }
        try {
            if (this.footerCallback != null) {
                this.footerCallback.write(this.delegateEventWriter);
            }
            this.delegateEventWriter.flush();
            this.endDocument(this.delegateEventWriter);
            return;
        }
        catch (IOException e) {
            throw new ItemStreamException("Failed to write footer items", e);
        }
        catch (XMLStreamException e) {
            throw new ItemStreamException("Failed to write end document tag", e);
        }
        finally {
            try {
                this.eventWriter.close();
            }
            catch (XMLStreamException xse) {
                log.error((Object)("Unable to close file resource: [" + this.resource + "] " + xse));
            }
            finally {
                try {
                    this.channel.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("Unable to close file resource: [" + this.resource + "] " + ioe));
                }
            }
        }
    }

    @Override
    public void write(List<? extends T> items) throws XmlMappingException, IOException {
        this.currentRecordCount += (long)items.size();
        for (T object : items) {
            Assert.state((boolean)this.marshaller.supports(object.getClass()), (String)"Marshaller must support the class of the marshalled object");
            this.marshaller.marshal(object, (Result)new StaxResult(this.eventWriter));
        }
        try {
            this.eventWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new WriteFailedException("Failed to flush the events", e);
        }
    }

    @Override
    public void update(ExecutionContext executionContext) {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(this.getKey(RESTART_DATA_NAME), this.getPosition());
            executionContext.putLong(this.getKey(WRITE_STATISTICS_NAME), this.currentRecordCount);
        }
    }

    private long getPosition() {
        long position;
        try {
            this.eventWriter.flush();
            position = this.channel.position();
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)e);
        }
        return position;
    }

    private void setPosition(long newPosition) {
        try {
            this.channel.truncate(newPosition);
            this.channel.position(newPosition);
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)e);
        }
    }
}

