/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.context;

import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.AtomicCounter;
import org.springframework.batch.repeat.context.AtomicCounterFactory;
import org.springframework.util.Assert;

public class RepeatContextCounter {
    private String countKey;
    private boolean useParent = false;
    private RepeatContext context;

    public final void increment(int delta) {
        AtomicCounter count = this.getCounter();
        count.addAndGet(delta);
    }

    public final void increment() {
        this.increment(1);
    }

    public RepeatContextCounter(RepeatContext context, String countKey) {
        this(context, countKey, false);
    }

    public RepeatContextCounter(RepeatContext context, String countKey, boolean useParent) {
        Assert.notNull((Object)context, (String)"The context must be provided");
        this.countKey = countKey;
        this.useParent = useParent;
        RepeatContext parent = context.getParent();
        this.context = this.useParent && parent != null ? parent : context;
        if (!this.context.hasAttribute(countKey)) {
            AtomicCounterFactory factory = new AtomicCounterFactory();
            this.context.setAttribute(countKey, factory.getAtomicCounter());
        }
    }

    public int getCount() {
        return this.getCounter().intValue();
    }

    private AtomicCounter getCounter() {
        return (AtomicCounter)this.context.getAttribute(this.countKey);
    }
}

