/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.oxm;

import java.io.IOException;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import org.springframework.batch.item.xml.EventWriterSerializer;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.oxm.Marshaller;
import org.springframework.xml.transform.StaxResult;

public class MarshallingEventWriterSerializer
implements EventWriterSerializer {
    private Marshaller marshaller;

    public MarshallingEventWriterSerializer(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void serializeObject(XMLEventWriter writer, Object output) {
        StaxResult result = new StaxResult(writer);
        try {
            this.marshaller.marshal(output, (Result)result);
        }
        catch (IOException xse) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + result.getSystemId() + "]", (Throwable)xse);
        }
    }
}

