/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.experimental.item.support;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;

public class CompositeItemReader<T>
implements ItemStreamReader<T> {
    private final List<ItemStreamReader<T>> delegates;
    private final Iterator<ItemStreamReader<T>> delegatesIterator;
    private ItemStreamReader<T> currentDelegate;

    public CompositeItemReader(List<ItemStreamReader<T>> delegates) {
        this.delegates = delegates;
        this.delegatesIterator = this.delegates.iterator();
        this.currentDelegate = this.delegatesIterator.hasNext() ? this.delegatesIterator.next() : null;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemStreamReader<T> delegate : this.delegates) {
            delegate.open(executionContext);
        }
    }

    public T read() throws Exception {
        if (this.currentDelegate == null) {
            return null;
        }
        Object item = this.currentDelegate.read();
        if (item == null) {
            this.currentDelegate = this.delegatesIterator.hasNext() ? this.delegatesIterator.next() : null;
            return this.read();
        }
        return (T)item;
    }

    public void close() throws ItemStreamException {
        for (ItemStreamReader<T> delegate : this.delegates) {
            delegate.close();
        }
    }
}

