/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.experimental.core.repository.dao;

import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MongoSequenceIncrementer
implements DataFieldMaxValueIncrementer {
    private final MongoOperations mongoTemplate;
    private final String sequenceName;

    public MongoSequenceIncrementer(MongoOperations mongoTemplate, String sequenceName) {
        this.mongoTemplate = mongoTemplate;
        this.sequenceName = sequenceName;
    }

    public long nextLongValue() throws DataAccessException {
        MongoSequence sequence = (MongoSequence)this.mongoTemplate.findOne(new Query(), MongoSequence.class, this.sequenceName);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)sequence.getId()));
        Update update = new Update().inc("count", (Number)1);
        this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, MongoSequence.class, this.sequenceName);
        return ((MongoSequence)this.mongoTemplate.findOne(new Query(), MongoSequence.class, this.sequenceName)).getCount();
    }

    public int nextIntValue() throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public String nextStringValue() throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public static final class MongoSequence {
        private String id;
        private long count;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public String toString() {
            return "MongoSequence{id='" + this.id + "', count=" + this.count + "}";
        }
    }
}

