/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.experimental.core.repository.dao;

import java.util.Collection;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.experimental.core.repository.persistence.ExecutionContext;
import org.springframework.batch.experimental.core.repository.persistence.converter.JobExecutionConverter;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class MongoExecutionContextDao
implements ExecutionContextDao {
    private static final String STEP_EXECUTIONS_COLLECTION_NAME = "BATCH_STEP_EXECUTION";
    private static final String JOB_EXECUTIONS_COLLECTION_NAME = "BATCH_JOB_EXECUTION";
    private final JobExecutionConverter jobExecutionConverter = new JobExecutionConverter();
    private final MongoOperations mongoOperations;

    public MongoExecutionContextDao(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public org.springframework.batch.item.ExecutionContext getExecutionContext(JobExecution jobExecution) {
        org.springframework.batch.experimental.core.repository.persistence.JobExecution execution = (org.springframework.batch.experimental.core.repository.persistence.JobExecution)this.mongoOperations.findById((Object)jobExecution.getId(), org.springframework.batch.experimental.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        if (execution == null) {
            return new org.springframework.batch.item.ExecutionContext();
        }
        return new org.springframework.batch.item.ExecutionContext(execution.getExecutionContext().map());
    }

    public org.springframework.batch.item.ExecutionContext getExecutionContext(StepExecution stepExecution) {
        org.springframework.batch.experimental.core.repository.persistence.StepExecution execution = (org.springframework.batch.experimental.core.repository.persistence.StepExecution)this.mongoOperations.findById((Object)stepExecution.getId(), org.springframework.batch.experimental.core.repository.persistence.StepExecution.class, STEP_EXECUTIONS_COLLECTION_NAME);
        if (execution == null) {
            return new org.springframework.batch.item.ExecutionContext();
        }
        return new org.springframework.batch.item.ExecutionContext(execution.getExecutionContext().map());
    }

    public void saveExecutionContext(JobExecution jobExecution) {
        org.springframework.batch.item.ExecutionContext executionContext = jobExecution.getExecutionContext();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)jobExecution.getId()));
        Map<String, Object> map = Map.ofEntries(executionContext.entrySet().toArray(new Map.Entry[0]));
        Update update = Update.update((String)"executionContext", (Object)new ExecutionContext(map, executionContext.isDirty()));
        this.mongoOperations.updateFirst(query, (UpdateDefinition)update, org.springframework.batch.experimental.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
    }

    public void saveExecutionContext(StepExecution stepExecution) {
        org.springframework.batch.item.ExecutionContext executionContext = stepExecution.getExecutionContext();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)stepExecution.getId()));
        Map<String, Object> map = Map.ofEntries(executionContext.entrySet().toArray(new Map.Entry[0]));
        Update update = Update.update((String)"executionContext", (Object)new ExecutionContext(map, executionContext.isDirty()));
        this.mongoOperations.updateFirst(query, (UpdateDefinition)update, org.springframework.batch.experimental.core.repository.persistence.StepExecution.class, STEP_EXECUTIONS_COLLECTION_NAME);
    }

    public void saveExecutionContexts(Collection<StepExecution> stepExecutions) {
        for (StepExecution stepExecution : stepExecutions) {
            this.saveExecutionContext(stepExecution);
        }
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        this.saveExecutionContext(jobExecution);
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        this.saveExecutionContext(stepExecution);
    }
}

