/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.resource;

import org.springframework.batch.admin.domain.DetailedJobInfo;
import org.springframework.batch.admin.domain.DetailedJobInfoResource;
import org.springframework.batch.admin.domain.JobExecutionInfo;
import org.springframework.batch.admin.domain.JobExecutionInfoResource;
import org.springframework.batch.admin.web.BatchJobsController;
import org.springframework.batch.admin.web.resource.JobExecutionInfoResourceAssembler;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;

public class DetailedJobInfoResourceAssembler
extends ResourceAssemblerSupport<DetailedJobInfo, DetailedJobInfoResource> {
    private JobExecutionInfoResourceAssembler jobExecutionInfoResourceAssembler = new JobExecutionInfoResourceAssembler();

    public DetailedJobInfoResourceAssembler() {
        super(BatchJobsController.class, DetailedJobInfoResource.class);
    }

    public DetailedJobInfoResource toResource(DetailedJobInfo entity) {
        return (DetailedJobInfoResource)this.createResourceWithId(entity.getName(), entity);
    }

    protected DetailedJobInfoResource instantiateResource(DetailedJobInfo entity) {
        JobExecutionInfoResource jobExecutionInfoResource;
        if (entity.getLastExecutionInfo() != null) {
            JobExecutionInfo jobExecutionInfo = new JobExecutionInfo(entity.getLastExecutionInfo().getJobExecution(), entity.getLastExecutionInfo().getTimeZone());
            jobExecutionInfoResource = this.jobExecutionInfoResourceAssembler.instantiateResource(jobExecutionInfo);
        } else {
            jobExecutionInfoResource = null;
        }
        return new DetailedJobInfoResource(entity.getName(), entity.getExecutionCount(), entity.isLaunchable(), entity.isIncrementable(), jobExecutionInfoResource);
    }
}

