/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.domain.NoSuchBatchJobException;
import org.springframework.batch.admin.domain.NoSuchBatchJobInstanceException;
import org.springframework.batch.admin.service.NoSuchStepExecutionException;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.VndErrors;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestControllerAdvice {
    private final Log logger = LogFactory.getLog(this.getClass());

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public VndErrors onMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public VndErrors onException(Exception e) {
        String logref = this.logError(e);
        String msg = StringUtils.hasText((String)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName();
        return new VndErrors(logref, msg, new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchJobExecutionException(NoSuchJobExecutionException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onJobExecutionNotRunningException(JobExecutionNotRunningException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchStepExecutionException(NoSuchStepExecutionException e) {
        String logref = this.logDebug((Throwable)((Object)e));
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    private String logDebug(Throwable t) {
        this.logger.debug((Object)"Caught exception while handling a request", t);
        return t.getClass().getSimpleName();
    }

    private String logError(Throwable t) {
        this.logger.error((Object)"Caught exception while handling a request", t);
        return t.getClass().getSimpleName();
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobExecutionAlreadyRunningException(JobExecutionAlreadyRunningException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobRestartException(JobRestartException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobInstanceAlreadyCompleteException(JobInstanceAlreadyCompleteException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchJobException(NoSuchBatchJobException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public VndErrors onNoSuchJobInstanceException(NoSuchBatchJobInstanceException e) {
        String logref = this.logDebug((Throwable)e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }

    @ResponseBody
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public VndErrors onJobParametersInvalidException(JobParametersInvalidException e) {
        String logref = this.logDebug(e);
        return new VndErrors(logref, e.getMessage(), new Link[0]);
    }
}

