/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.admin.domain.DetailedJobInfo;
import org.springframework.batch.admin.domain.DetailedJobInfoResource;
import org.springframework.batch.admin.domain.JobExecutionInfo;
import org.springframework.batch.admin.domain.NoSuchBatchJobException;
import org.springframework.batch.admin.web.AbstractBatchJobsController;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/batch/configurations"})
@ExposesResourceFor(value=DetailedJobInfoResource.class)
public class BatchJobsController
extends AbstractBatchJobsController {
    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<DetailedJobInfoResource> jobs(Pageable pageable, PagedResourcesAssembler<DetailedJobInfo> assembler) {
        int total = this.jobService.countJobs();
        Collection<String> names = this.jobService.listJobs(pageable.getOffset(), pageable.getPageSize());
        ArrayList<DetailedJobInfo> detailedJobs = new ArrayList<DetailedJobInfo>();
        for (String name : names) {
            detailedJobs.add(this.getJobInfo(name));
        }
        return assembler.toResource((Page)new PageImpl(detailedJobs, pageable, (long)total), (ResourceAssembler)this.jobInfoResourceAssembler);
    }

    @RequestMapping(value={"/{jobName}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public DetailedJobInfoResource jobinfo(@PathVariable String jobName) {
        return this.getJobInfoResource(jobName);
    }

    private DetailedJobInfoResource getJobInfoResource(String jobName) {
        return this.jobInfoResourceAssembler.toResource(this.getJobInfo(jobName));
    }

    private DetailedJobInfo getJobInfo(String jobName) {
        boolean launchable = this.jobService.isLaunchable(jobName);
        try {
            int count = this.jobService.countJobExecutionsForJob(jobName);
            return new DetailedJobInfo(jobName, count, launchable, this.jobService.isIncrementable(jobName), this.getLastExecution(jobName));
        }
        catch (NoSuchJobException e) {
            throw new NoSuchBatchJobException(jobName);
        }
    }

    private JobExecutionInfo getLastExecution(String jobName) throws NoSuchJobException {
        Collection<JobExecution> executions = this.jobService.listJobExecutionsForJob(jobName, 0, 1);
        if (executions.size() > 0) {
            return new JobExecutionInfo(executions.iterator().next(), this.timeZone);
        }
        return null;
    }
}

