/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.batch.operations.JobOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.service.NoSuchStepExecutionException;
import org.springframework.batch.admin.service.SearchableJobExecutionDao;
import org.springframework.batch.admin.service.SearchableJobInstanceDao;
import org.springframework.batch.admin.service.SearchableStepExecutionDao;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobInstanceException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;

public class SimpleJobService
implements JobService,
DisposableBean {
    private static final Log logger = LogFactory.getLog(SimpleJobService.class);
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 60000;
    private final SearchableJobInstanceDao jobInstanceDao;
    private final SearchableJobExecutionDao jobExecutionDao;
    private final JobRepository jobRepository;
    private final JobLauncher jobLauncher;
    private final ListableJobLocator jobLocator;
    private final SearchableStepExecutionDao stepExecutionDao;
    private final ExecutionContextDao executionContextDao;
    private Collection<JobExecution> activeExecutions = Collections.synchronizedList(new ArrayList());
    private JobOperator jsrJobOperator;
    private int shutdownTimeout = 60000;

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public SimpleJobService(SearchableJobInstanceDao jobInstanceDao, SearchableJobExecutionDao jobExecutionDao, SearchableStepExecutionDao stepExecutionDao, JobRepository jobRepository, JobLauncher jobLauncher, ListableJobLocator jobLocator, ExecutionContextDao executionContextDao) {
        this(jobInstanceDao, jobExecutionDao, stepExecutionDao, jobRepository, jobLauncher, jobLocator, executionContextDao, null);
    }

    public SimpleJobService(SearchableJobInstanceDao jobInstanceDao, SearchableJobExecutionDao jobExecutionDao, SearchableStepExecutionDao stepExecutionDao, JobRepository jobRepository, JobLauncher jobLauncher, ListableJobLocator jobLocator, ExecutionContextDao executionContextDao, JobOperator jsrJobOperator) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.jobRepository = jobRepository;
        this.jobLauncher = jobLauncher;
        this.jobLocator = jobLocator;
        this.executionContextDao = executionContextDao;
        if (jsrJobOperator == null) {
            logger.warn((Object)"No JobOperator compatible with JSR-352 was provided.");
        } else {
            this.jsrJobOperator = jsrJobOperator;
        }
    }

    @Override
    public Collection<StepExecution> getStepExecutions(Long jobExecutionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("No JobExecution with id=" + jobExecutionId);
        }
        this.stepExecutionDao.addStepExecutions(jobExecution);
        String jobName = jobExecution.getJobInstance() == null ? this.jobInstanceDao.getJobInstance(jobExecution).getJobName() : jobExecution.getJobInstance().getJobName();
        LinkedHashSet<String> missingStepNames = new LinkedHashSet<String>();
        if (jobName != null) {
            missingStepNames.addAll(this.stepExecutionDao.findStepNamesForJobExecution(jobName, "*:partition*"));
            logger.debug((Object)("Found step executions in repository: " + missingStepNames));
        }
        Job job = null;
        try {
            job = this.jobLocator.getJob(jobName);
        }
        catch (NoSuchJobException e) {
            // empty catch block
        }
        if (job instanceof StepLocator) {
            Collection stepNames = ((StepLocator)job).getStepNames();
            missingStepNames.addAll(stepNames);
            logger.debug((Object)("Added step executions from job: " + missingStepNames));
        }
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            String stepName = stepExecution.getStepName();
            if (missingStepNames.contains(stepName)) {
                missingStepNames.remove(stepName);
            }
            logger.debug((Object)("Removed step executions from job execution: " + missingStepNames));
        }
        for (String stepName : missingStepNames) {
            StepExecution stepExecution = jobExecution.createStepExecution(stepName);
            stepExecution.setStatus(BatchStatus.UNKNOWN);
        }
        return jobExecution.getStepExecutions();
    }

    @Override
    public boolean isLaunchable(String jobName) {
        return this.jobLocator.getJobNames().contains(jobName) || this.getJsrJobNames().contains(jobName);
    }

    @Override
    public boolean isIncrementable(String jobName) {
        try {
            return this.jobLocator.getJobNames().contains(jobName) && this.jobLocator.getJob(jobName).getJobParametersIncrementer() != null;
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException("Unexpected non-existent job: " + jobName);
        }
    }

    @Override
    public JobExecution restart(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, NoSuchJobException, JobParametersInvalidException {
        return this.restart(jobExecutionId, null);
    }

    @Override
    public JobExecution restart(Long jobExecutionId, JobParameters params) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, NoSuchJobException, JobParametersInvalidException {
        JobExecution jobExecution = null;
        JobExecution target = this.getJobExecution(jobExecutionId);
        JobInstance lastInstance = target.getJobInstance();
        if (this.jobLocator.getJobNames().contains(lastInstance.getJobName())) {
            Job job = this.jobLocator.getJob(lastInstance.getJobName());
            jobExecution = this.jobLauncher.run(job, target.getJobParameters());
            if (jobExecution.isRunning()) {
                this.activeExecutions.add(jobExecution);
            }
        } else if (this.jsrJobOperator != null) {
            jobExecution = params != null ? new JobExecution(Long.valueOf(this.jsrJobOperator.restart(jobExecutionId.longValue(), params.toProperties()))) : new JobExecution(Long.valueOf(this.jsrJobOperator.restart(jobExecutionId.longValue(), new Properties())));
        } else {
            throw new NoSuchJobException(String.format("Can't find job associated with job execution id %s to restart", String.valueOf(jobExecutionId)));
        }
        return jobExecution;
    }

    @Override
    public JobExecution launch(String jobName, JobParameters jobParameters) throws NoSuchJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobExecution jobExecution = null;
        if (this.jobLocator.getJobNames().contains(jobName)) {
            BatchStatus status;
            Job job = this.jobLocator.getJob(jobName);
            JobExecution lastJobExecution = this.jobRepository.getLastJobExecution(jobName, jobParameters);
            boolean restart = false;
            if (lastJobExecution != null && (status = lastJobExecution.getStatus()).isUnsuccessful() && status != BatchStatus.ABANDONED) {
                restart = true;
            }
            if (job.getJobParametersIncrementer() != null && !restart) {
                jobParameters = job.getJobParametersIncrementer().getNext(jobParameters);
            }
            if ((jobExecution = this.jobLauncher.run(job, jobParameters)).isRunning()) {
                this.activeExecutions.add(jobExecution);
            }
        } else if (this.jsrJobOperator != null) {
            jobExecution = new JobExecution(Long.valueOf(this.jsrJobOperator.start(jobName, jobParameters.toProperties())));
        } else {
            throw new NoSuchJobException(String.format("Unable to find job %s to launch", String.valueOf(jobName)));
        }
        return jobExecution;
    }

    @Override
    public JobParameters getLastJobParameters(String jobName) throws NoSuchJobException {
        List<JobExecution> executions = this.jobExecutionDao.getJobExecutions(jobName, 0, 1);
        JobExecution lastExecution = null;
        if (!CollectionUtils.isEmpty(executions)) {
            lastExecution = (JobExecution)executions.iterator().next();
        }
        JobParameters oldParameters = new JobParameters();
        if (lastExecution != null) {
            oldParameters = lastExecution.getJobParameters();
        }
        return oldParameters;
    }

    @Override
    public Collection<JobExecution> listJobExecutions(int start, int count) {
        return this.jobExecutionDao.getJobExecutions(start, count);
    }

    @Override
    public int countJobExecutions() {
        return this.jobExecutionDao.countJobExecutions();
    }

    @Override
    public Collection<String> listJobs(int start, int count) {
        LinkedHashSet<String> jobNames = new LinkedHashSet<String>(this.jobLocator.getJobNames());
        jobNames.addAll(this.getJsrJobNames());
        if (start + count > jobNames.size()) {
            jobNames.addAll(this.jobInstanceDao.getJobNames());
        }
        if (start >= jobNames.size()) {
            start = jobNames.size();
        }
        if (start + count >= jobNames.size()) {
            count = jobNames.size() - start;
        }
        return new ArrayList(jobNames).subList(start, start + count);
    }

    private Collection<String> getJsrJobNames() {
        ClassPathResource jsrJobsDirectory = new ClassPathResource("/META-INF/batch-jobs");
        HashSet<String> jsr352JobNames = new HashSet<String>();
        if (jsrJobsDirectory.exists()) {
            try {
                File[] jobXmlFiles;
                for (File jobXmlFile : jobXmlFiles = jsrJobsDirectory.getFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                })) {
                    jsr352JobNames.add(jobXmlFile.getName().substring(0, jobXmlFile.getName().length() - 4));
                }
            }
            catch (IOException e) {
                logger.debug((Object)"Unable to list JSR-352 batch jobs", (Throwable)e);
            }
        }
        return jsr352JobNames;
    }

    @Override
    public int countJobs() {
        HashSet names = new HashSet(this.jobLocator.getJobNames());
        names.addAll(this.jobInstanceDao.getJobNames());
        return names.size();
    }

    @Override
    public int stopAll() {
        Collection<JobExecution> result = this.jobExecutionDao.getRunningJobExecutions();
        Collection<String> jsrJobNames = this.getJsrJobNames();
        for (JobExecution jobExecution : result) {
            if (this.jsrJobOperator != null && jsrJobNames.contains(jobExecution.getJobInstance().getJobName())) {
                this.jsrJobOperator.stop(jobExecution.getId().longValue());
                continue;
            }
            jobExecution.stop();
            this.jobRepository.update(jobExecution);
        }
        return result.size();
    }

    @Override
    public JobExecution stop(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        if (!jobExecution.isRunning()) {
            throw new JobExecutionNotRunningException("JobExecution is not running and therefore cannot be stopped");
        }
        logger.info((Object)("Stopping job execution: " + jobExecution));
        Collection<String> jsrJobNames = this.getJsrJobNames();
        if (this.jsrJobOperator != null && jsrJobNames.contains(jobExecution.getJobInstance().getJobName())) {
            this.jsrJobOperator.stop(jobExecutionId.longValue());
            jobExecution = this.getJobExecution(jobExecutionId);
        } else {
            jobExecution.stop();
            this.jobRepository.update(jobExecution);
        }
        return jobExecution;
    }

    @Override
    public JobExecution abandon(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        if (jobExecution.getStatus().isLessThan(BatchStatus.STOPPING)) {
            throw new JobExecutionAlreadyRunningException("JobExecution is running or complete and therefore cannot be aborted");
        }
        logger.info((Object)("Aborting job execution: " + jobExecution));
        Collection<String> jsrJobNames = this.getJsrJobNames();
        JobInstance jobInstance = jobExecution.getJobInstance();
        if (this.jsrJobOperator != null && jsrJobNames.contains(jobInstance.getJobName())) {
            this.jsrJobOperator.abandon(jobExecutionId.longValue());
            jobExecution = this.getJobExecution(jobExecutionId);
        } else {
            jobExecution.upgradeStatus(BatchStatus.ABANDONED);
            jobExecution.setEndTime(new Date());
            this.jobRepository.update(jobExecution);
        }
        return jobExecution;
    }

    @Override
    public int countJobExecutionsForJob(String name) throws NoSuchJobException {
        this.checkJobExists(name);
        return this.jobExecutionDao.countJobExecutions(name);
    }

    @Override
    public int countJobInstances(String name) throws NoSuchJobException {
        return this.jobInstanceDao.countJobInstances(name);
    }

    @Override
    public JobExecution getJobExecution(Long jobExecutionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("There is no JobExecution with id=" + jobExecutionId);
        }
        jobExecution.setJobInstance(this.jobInstanceDao.getJobInstance(jobExecution));
        try {
            jobExecution.setExecutionContext(this.executionContextDao.getExecutionContext(jobExecution));
        }
        catch (Exception e) {
            logger.info((Object)("Cannot load execution context for job execution: " + jobExecution));
        }
        this.stepExecutionDao.addStepExecutions(jobExecution);
        return jobExecution;
    }

    @Override
    public Collection<JobExecution> getJobExecutionsForJobInstance(String name, Long jobInstanceId) throws NoSuchJobException {
        this.checkJobExists(name);
        List jobExecutions = this.jobExecutionDao.findJobExecutions(this.jobInstanceDao.getJobInstance(jobInstanceId));
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecutions;
    }

    @Override
    public StepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) throws NoSuchJobExecutionException, NoSuchStepExecutionException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        StepExecution stepExecution = this.stepExecutionDao.getStepExecution(jobExecution, stepExecutionId);
        if (stepExecution == null) {
            throw new NoSuchStepExecutionException("There is no StepExecution with jobExecutionId=" + jobExecutionId + " and id=" + stepExecutionId);
        }
        try {
            stepExecution.setExecutionContext(this.executionContextDao.getExecutionContext(stepExecution));
        }
        catch (Exception e) {
            logger.info((Object)("Cannot load execution context for step execution: " + stepExecution));
        }
        return stepExecution;
    }

    @Override
    public Collection<JobExecution> listJobExecutionsForJob(String jobName, int start, int count) throws NoSuchJobException {
        this.checkJobExists(jobName);
        List<JobExecution> jobExecutions = this.jobExecutionDao.getJobExecutions(jobName, start, count);
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecutions;
    }

    @Override
    public Collection<StepExecution> listStepExecutionsForStep(String jobName, String stepName, int start, int count) throws NoSuchStepException {
        if (this.stepExecutionDao.countStepExecutions(jobName, stepName) == 0) {
            throw new NoSuchStepException("No step executions exist with this step name: " + stepName);
        }
        return this.stepExecutionDao.findStepExecutions(jobName, stepName, start, count);
    }

    @Override
    public int countStepExecutionsForStep(String jobName, String stepName) throws NoSuchStepException {
        return this.stepExecutionDao.countStepExecutions(jobName, stepName);
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) throws NoSuchJobInstanceException {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobInstanceId);
        if (jobInstance == null) {
            throw new NoSuchJobInstanceException("JobInstance with id=" + jobInstanceId + " does not exist");
        }
        return jobInstance;
    }

    @Override
    public Collection<JobInstance> listJobInstances(String jobName, int start, int count) throws NoSuchJobException {
        this.checkJobExists(jobName);
        return this.jobInstanceDao.getJobInstances(jobName, start, count);
    }

    @Override
    public Collection<String> getStepNamesForJob(String jobName) throws NoSuchJobException {
        try {
            Job job = this.jobLocator.getJob(jobName);
            if (job instanceof StepLocator) {
                return ((StepLocator)job).getStepNames();
            }
        }
        catch (NoSuchJobException e) {
            // empty catch block
        }
        LinkedHashSet<String> stepNames = new LinkedHashSet<String>();
        for (JobExecution jobExecution : this.listJobExecutionsForJob(jobName, 0, 100)) {
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                stepNames.add(stepExecution.getStepName());
            }
        }
        return Collections.unmodifiableList(new ArrayList(stepNames));
    }

    private void checkJobExists(String jobName) throws NoSuchJobException {
        if (this.getJsrJobNames().contains(jobName)) {
            return;
        }
        if (this.jobLocator.getJobNames().contains(jobName)) {
            return;
        }
        if (this.jobInstanceDao.countJobInstances(jobName) > 0) {
            return;
        }
        throw new NoSuchJobException("No Job with that name either current or historic: [" + jobName + "]");
    }

    public void destroy() throws Exception {
        Exception firstException = null;
        for (JobExecution jobExecution : this.activeExecutions) {
            try {
                if (!jobExecution.isRunning()) continue;
                this.stop(jobExecution.getId());
            }
            catch (JobExecutionNotRunningException e) {
                logger.info((Object)"JobExecution is not running so it cannot be stopped");
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected exception stopping JobExecution", (Throwable)e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        int count = 0;
        int maxCount = (this.shutdownTimeout + 1000) / 1000;
        while (!this.activeExecutions.isEmpty() && ++count < maxCount) {
            logger.error((Object)("Waiting for " + this.activeExecutions.size() + " active executions to complete"));
            this.removeInactiveExecutions();
            Thread.sleep(1000L);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void removeInactiveExecutions() {
        Iterator<JobExecution> iterator = this.activeExecutions.iterator();
        while (iterator.hasNext()) {
            JobExecution jobExecution = iterator.next();
            try {
                jobExecution = this.getJobExecution(jobExecution.getId());
            }
            catch (NoSuchJobExecutionException e) {
                logger.error((Object)"Unexpected exception loading JobExecution", (Throwable)e);
            }
            if (jobExecution.isRunning()) continue;
            iterator.remove();
        }
    }
}

