/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.jmx;

import java.util.Collection;
import java.util.Date;
import org.springframework.batch.admin.domain.StepExecutionHistory;
import org.springframework.batch.admin.jmx.StepExecutionMetrics;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.StepExecution;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class SimpleStepExecutionMetrics
implements StepExecutionMetrics {
    private final JobService jobService;
    private final String stepName;
    private final String jobName;

    public SimpleStepExecutionMetrics(JobService jobService, String jobName, String stepName) {
        this.jobService = jobService;
        this.jobName = jobName;
        this.stepName = stepName;
    }

    @Override
    public int getExecutionCount() {
        return this.jobService.countStepExecutionsForStep(this.jobName, this.stepName);
    }

    @Override
    public int getFailureCount() {
        Collection<StepExecution> stepExecutions;
        int count = 0;
        int start = 0;
        int pageSize = 100;
        do {
            stepExecutions = this.jobService.listStepExecutionsForStep(this.jobName, this.stepName, start, pageSize);
            start += pageSize;
            for (StepExecution stepExecution : stepExecutions) {
                if (!stepExecution.getStatus().isUnsuccessful()) continue;
                ++count;
            }
        } while (!stepExecutions.isEmpty());
        return count;
    }

    @Override
    public double getLatestDuration() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        if (stepExecution == null) {
            return 0.0;
        }
        Date endTime = stepExecution.getEndTime();
        return (endTime != null ? endTime.getTime() : System.currentTimeMillis()) - stepExecution.getStartTime().getTime();
    }

    @Override
    public double getMeanDuration() {
        StepExecutionHistory history = this.computeHistory(this.stepName);
        return history.getDuration().getMean();
    }

    @Override
    public double getMaxDuration() {
        StepExecutionHistory history = this.computeHistory(this.stepName);
        return history.getDuration().getMax();
    }

    @Override
    public int getLatestReadCount() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? 0 : stepExecution.getReadCount();
    }

    @Override
    public int getLatestWriteCount() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? 0 : stepExecution.getWriteCount();
    }

    @Override
    public int getLatestFilterCount() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? 0 : stepExecution.getFilterCount();
    }

    @Override
    public int getLatestSkipCount() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? 0 : stepExecution.getSkipCount();
    }

    @Override
    public int getLatestCommitCount() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? 0 : stepExecution.getCommitCount();
    }

    @Override
    public int getLatestRollbackCount() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? 0 : stepExecution.getRollbackCount();
    }

    @Override
    public long getLatestExecutionId() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? -1L : stepExecution.getId();
    }

    @Override
    public String getLatestStatus() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? "NON" : stepExecution.getStatus().toString();
    }

    @Override
    public String getLatestExitCode() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? "NONE" : stepExecution.getExitStatus().getExitCode();
    }

    @Override
    public String getLatestExitDescription() {
        StepExecution stepExecution = this.getLatestStepExecution(this.stepName);
        return stepExecution == null ? "" : stepExecution.getExitStatus().getExitDescription();
    }

    private StepExecutionHistory computeHistory(String stepName) {
        return this.computeHistory(stepName, 10);
    }

    private StepExecution getLatestStepExecution(String stepName) {
        Collection<StepExecution> stepExecutions = this.jobService.listStepExecutionsForStep(this.jobName, stepName, 0, 4);
        if (stepExecutions.isEmpty()) {
            return null;
        }
        long lastUpdated = 0L;
        StepExecution result = null;
        for (StepExecution stepExecution : stepExecutions) {
            long updated = stepExecution.getStartTime().getTime();
            if (updated <= lastUpdated) continue;
            result = stepExecution;
            lastUpdated = updated;
        }
        return result;
    }

    private StepExecutionHistory computeHistory(String stepName, int total) {
        StepExecutionHistory stepExecutionHistory = new StepExecutionHistory(stepName);
        for (StepExecution stepExecution : this.jobService.listStepExecutionsForStep(this.jobName, stepName, 0, total)) {
            stepExecutionHistory.append(stepExecution);
        }
        return stepExecutionHistory;
    }
}

