/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CompositeApplicationContextFactory
implements FactoryBean<ApplicationContextFactory[]>,
InitializingBean {
    private List<FactoryBean<ApplicationContextFactory[]>> factoryBeans;
    private List<ApplicationContextFactory> delegateFactories;

    public void setFactoryBeans(List<FactoryBean<ApplicationContextFactory[]>> factoryBeans) {
        this.factoryBeans = factoryBeans;
    }

    public void setFactories(List<ApplicationContextFactory> delegateFactories) {
        this.delegateFactories = delegateFactories;
    }

    public ApplicationContextFactory[] getObject() throws Exception {
        ArrayList<Object> factories = new ArrayList<Object>();
        if (this.factoryBeans != null) {
            for (FactoryBean<ApplicationContextFactory[]> factory : this.factoryBeans) {
                factories.addAll(Arrays.asList((Object[])factory.getObject()));
            }
        }
        if (this.delegateFactories != null) {
            factories.addAll(this.delegateFactories);
        }
        return factories.toArray(new ApplicationContextFactory[factories.size()]);
    }

    public Class<?> getObjectType() {
        return ApplicationContextFactory[].class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((!CollectionUtils.isEmpty(this.factoryBeans) || !CollectionUtils.isEmpty(this.delegateFactories) ? 1 : 0) != 0, (String)"A factory or factoryBean is required");
    }
}

