/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;

public class JobInstanceInfo {
    private final JobInstance jobInstance;
    private final Long id;
    private final Collection<JobExecutionInfo> jobExecutionInfos;

    public JobInstanceInfo(JobInstance jobInstance, Collection<JobExecution> jobExecutions, TimeZone timeZone) {
        this.jobInstance = jobInstance;
        this.jobExecutionInfos = new ArrayList<JobExecutionInfo>();
        if (jobExecutions != null) {
            for (JobExecution jobExecution : jobExecutions) {
                this.jobExecutionInfos.add(new JobExecutionInfo(jobExecution, timeZone));
            }
        }
        this.id = jobInstance.getId();
    }

    public JobInstanceInfo(JobInstance jobInstance, Collection<JobExecution> jobExecutions) {
        this(jobInstance, jobExecutions, TimeZone.getDefault());
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public Long getId() {
        return this.id;
    }

    public int getJobExecutionCount() {
        return this.jobExecutionInfos.size();
    }

    public Collection<JobExecution> getJobExecutions() {
        ArrayList<JobExecution> jobExecutions = new ArrayList<JobExecution>();
        for (JobExecutionInfo jobExecutionInfo : this.jobExecutionInfos) {
            jobExecutions.add(jobExecutionInfo.getJobExecution());
        }
        return jobExecutions;
    }

    public JobExecution getLastJobExecution() {
        return this.jobExecutionInfos.isEmpty() ? null : this.jobExecutionInfos.iterator().next().getJobExecution();
    }

    public JobExecutionInfo getLastJobExecutionInfo() {
        return this.jobExecutionInfos.isEmpty() ? null : this.jobExecutionInfos.iterator().next();
    }
}

