/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.beans.PropertyEditorSupport;
import org.springframework.batch.admin.service.FileService;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileServiceResourceConverter
extends PropertyEditorSupport
implements Converter<String, Resource>,
ResourceLoaderAware {
    private static FileService fileService;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public FileServiceResourceConverter() {
    }

    public FileServiceResourceConverter(FileService fileService) {
        FileServiceResourceConverter.fileService = fileService;
    }

    public void setFileService(FileService fileService) {
        FileServiceResourceConverter.fileService = fileService;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Resource convert(String source) {
        Resource file;
        String path = source;
        if (path.startsWith("files:") && (file = fileService.getResource(path)) != null) {
            return file;
        }
        return this.resourceLoader.getResource(source);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.convert(text));
    }
}

