/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.beans.PropertyEditor;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

public class CustomWebBindingInitializer
extends ConfigurableWebBindingInitializer
implements BeanFactoryAware {
    private AbstractBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (AbstractBeanFactory)beanFactory;
    }

    public void initBinder(WebDataBinder binder, WebRequest request) {
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter((Converter)new MultipartFileConverter((DataBinder)binder));
        binder.setConversionService((ConversionService)conversionService);
        if (this.beanFactory != null) {
            this.beanFactory.copyRegisteredEditorsTo((PropertyEditorRegistry)binder);
        }
        super.initBinder(binder, request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultipartFileConverter
    implements Converter<MultipartFile, String> {
        private final DataBinder accessor;

        public MultipartFileConverter(DataBinder accessor) {
            this.accessor = accessor;
        }

        public String convert(MultipartFile source) {
            PropertyEditor editor = this.accessor.findCustomEditor(MultipartFile.class, null);
            if (editor == null) {
                throw new IllegalStateException("Cannot convert source of type " + source.getClass() + " to type: String");
            }
            editor.setValue(source);
            return editor.getAsText();
        }
    }
}

