/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.springframework.batch.admin.integration.FileUploadRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class FileUploadRequestToFileAdapter
implements InitializingBean {
    private File directory = new File("target/data");

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void afterPropertiesSet() {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IllegalStateException("Cannot delete directory " + this.directory);
        }
    }

    @ServiceActivator
    public File convert(FileUploadRequest request) throws Exception {
        if (request.getData() == null) {
            throw new IllegalArgumentException("Null input data");
        }
        File tempFile = File.createTempFile("lead-data-", ".txt");
        FileUtils.writeStringToFile((File)tempFile, (String)request.getData());
        return tempFile;
    }
}

