/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

@XmlRootElement
public class StepExecutionInfoResource
extends ResourceSupport {
    private DateTimeFormatter dateFormat = ISODateTimeFormat.dateTime();
    private Long executionId;
    private Long jobExecutionId;
    private String stepType;
    private String stepName;
    private BatchStatus status;
    private int readCount;
    private int writeCount;
    private int commitCount;
    private int rollbackCount;
    private int readSkipCount;
    private int processSkipCount;
    private int writeSkipCount;
    private String startTime;
    private String endTime;
    private String lastUpdated;
    private Map<String, Object> executionContext;
    private ExitStatus exitStatus;
    private boolean terminateOnly;
    private int filterCount;
    private List<Throwable> failureExceptions;
    private Integer version;
    private final TimeZone timeZone;

    public StepExecutionInfoResource(StepExecution stepExecution, TimeZone timeZone) {
        Assert.notNull((Object)stepExecution, (String)"stepExecution must not be null.");
        this.timeZone = timeZone != null ? timeZone : TimeZone.getTimeZone("UTC");
        this.dateFormat = this.dateFormat.withZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
        this.jobExecutionId = stepExecution.getJobExecutionId();
        if (stepExecution.getExecutionContext().containsKey("batch.stepType")) {
            this.stepType = (String)stepExecution.getExecutionContext().get("batch.stepType");
        }
        this.executionId = stepExecution.getId();
        this.stepName = stepExecution.getStepName();
        this.status = stepExecution.getStatus();
        this.readCount = stepExecution.getReadCount();
        this.writeCount = stepExecution.getWriteCount();
        this.commitCount = stepExecution.getCommitCount();
        this.rollbackCount = stepExecution.getRollbackCount();
        this.readSkipCount = stepExecution.getReadSkipCount();
        this.processSkipCount = stepExecution.getProcessSkipCount();
        this.writeSkipCount = stepExecution.getWriteSkipCount();
        this.startTime = this.dateFormat.print(stepExecution.getStartTime().getTime());
        this.endTime = stepExecution.getEndTime() != null ? this.dateFormat.print(stepExecution.getEndTime().getTime()) : this.dateFormat.print(new Date().getTime());
        this.lastUpdated = this.dateFormat.print(stepExecution.getLastUpdated().getTime());
        HashMap<String, Object> executionContextValues = new HashMap<String, Object>();
        for (Map.Entry stringObjectEntry : stepExecution.getExecutionContext().entrySet()) {
            executionContextValues.put((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        this.executionContext = executionContextValues;
        this.exitStatus = stepExecution.getExitStatus();
        this.terminateOnly = stepExecution.isTerminateOnly();
        this.filterCount = stepExecution.getFilterCount();
        this.failureExceptions = stepExecution.getFailureExceptions();
        this.version = stepExecution.getVersion();
    }

    public StepExecutionInfoResource() {
        this.timeZone = TimeZone.getTimeZone("UTC");
    }

    public Long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public String getStepType() {
        return this.stepType;
    }

    public String getStepName() {
        return this.stepName;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public int getRollbackCount() {
        return this.rollbackCount;
    }

    public int getReadSkipCount() {
        return this.readSkipCount;
    }

    public int getProcessSkipCount() {
        return this.processSkipCount;
    }

    public int getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public Map<String, Object> getExecutionContext() {
        return this.executionContext;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Long getExecutionId() {
        return this.executionId;
    }
}

