/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

import java.util.Date;
import org.springframework.batch.admin.domain.CumulativeHistory;
import org.springframework.batch.core.StepExecution;

public class StepExecutionHistory {
    private final String stepName;
    private int count = 0;
    private CumulativeHistory commitCount = new CumulativeHistory();
    private CumulativeHistory rollbackCount = new CumulativeHistory();
    private CumulativeHistory readCount = new CumulativeHistory();
    private CumulativeHistory writeCount = new CumulativeHistory();
    private CumulativeHistory filterCount = new CumulativeHistory();
    private CumulativeHistory readSkipCount = new CumulativeHistory();
    private CumulativeHistory writeSkipCount = new CumulativeHistory();
    private CumulativeHistory processSkipCount = new CumulativeHistory();
    private CumulativeHistory duration = new CumulativeHistory();
    private CumulativeHistory durationPerRead = new CumulativeHistory();

    public StepExecutionHistory(String stepName) {
        this.stepName = stepName;
    }

    public void append(StepExecution stepExecution) {
        if (stepExecution.getEndTime() == null) {
            return;
        }
        Date startTime = stepExecution.getStartTime();
        Date endTime = stepExecution.getEndTime();
        long time = endTime.getTime() - startTime.getTime();
        this.duration.append(time);
        if (stepExecution.getReadCount() > 0) {
            this.durationPerRead.append(time / (long)stepExecution.getReadCount());
        }
        ++this.count;
        this.commitCount.append(stepExecution.getCommitCount());
        this.rollbackCount.append(stepExecution.getRollbackCount());
        this.readCount.append(stepExecution.getReadCount());
        this.writeCount.append(stepExecution.getWriteCount());
        this.filterCount.append(stepExecution.getFilterCount());
        this.readSkipCount.append(stepExecution.getReadSkipCount());
        this.writeSkipCount.append(stepExecution.getWriteSkipCount());
        this.processSkipCount.append(stepExecution.getProcessSkipCount());
    }

    public String getStepName() {
        return this.stepName;
    }

    public int getCount() {
        return this.count;
    }

    public CumulativeHistory getCommitCount() {
        return this.commitCount;
    }

    public CumulativeHistory getRollbackCount() {
        return this.rollbackCount;
    }

    public CumulativeHistory getReadCount() {
        return this.readCount;
    }

    public CumulativeHistory getWriteCount() {
        return this.writeCount;
    }

    public CumulativeHistory getFilterCount() {
        return this.filterCount;
    }

    public CumulativeHistory getReadSkipCount() {
        return this.readSkipCount;
    }

    public CumulativeHistory getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public CumulativeHistory getProcessSkipCount() {
        return this.processSkipCount;
    }

    public CumulativeHistory getDuration() {
        return this.duration;
    }

    public CumulativeHistory getDurationPerRead() {
        return this.durationPerRead;
    }
}

