/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.extensions.excel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.extensions.excel.ExcelFileParseException;
import org.springframework.batch.extensions.excel.RowCallbackHandler;
import org.springframework.batch.extensions.excel.RowMapper;
import org.springframework.batch.extensions.excel.Sheet;
import org.springframework.batch.extensions.excel.support.rowset.DefaultRowSetFactory;
import org.springframework.batch.extensions.excel.support.rowset.RowSet;
import org.springframework.batch.extensions.excel.support.rowset.RowSetFactory;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractExcelItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Resource resource;
    private int linesToSkip = 0;
    private int currentSheet = 0;
    private int endAfterBlankLines = 1;
    private RowMapper<T> rowMapper;
    private RowCallbackHandler skippedRowsCallback;
    private boolean noInput = false;
    private boolean strict = true;
    private RowSetFactory rowSetFactory = new DefaultRowSetFactory();
    private RowSet rs;
    private String password;

    public AbstractExcelItemReader() {
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
    }

    public T read() throws Exception {
        Object item = super.read();
        int blankLines = 0;
        while (item == null) {
            if (++blankLines >= this.endAfterBlankLines) {
                return null;
            }
            item = super.read();
            if (item == null) continue;
            return (T)item;
        }
        return (T)item;
    }

    protected T doRead() {
        if (this.noInput) {
            return null;
        }
        if (!(this.rs != null && this.rs.next() || this.nextSheet())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No more sheets in '" + this.resource.getDescription() + "'."));
            }
            return null;
        }
        while (null != this.rs.getCurrentRow() && this.isInvalidValidRow(this.rs)) {
            this.rs.next();
        }
        try {
            return this.rs.getCurrentRow() != null ? (T)this.rowMapper.mapRow(this.rs) : null;
        }
        catch (Exception ex) {
            throw new ExcelFileParseException("Exception parsing Excel file.", ex, this.resource.getDescription(), this.rs.getMetaData().getSheetName(), this.rs.getCurrentRowIndex(), this.rs.getCurrentRow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jumpToItem(int itemIndex) {
        RowMapper<T> current = this.rowMapper;
        this.rowMapper = rs -> null;
        try {
            for (int i = 0; i < itemIndex; ++i) {
                this.doRead();
            }
        }
        finally {
            this.rowMapper = current;
        }
    }

    private boolean isInvalidValidRow(RowSet rs) {
        for (String str : rs.getCurrentRow()) {
            if (str.length() <= 0) continue;
            return false;
        }
        return true;
    }

    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + this.resource);
            }
            this.logger.warn((Object)("Input resource does not exist '" + this.resource.getDescription() + "'."));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode): " + this.resource);
            }
            this.logger.warn((Object)("Input resource is not readable '" + this.resource.getDescription() + "'."));
            return;
        }
        this.openExcelFile(this.resource, this.password);
        this.noInput = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened workbook [" + this.resource.getFilename() + "] with " + this.getNumberOfSheets() + " sheets."));
        }
    }

    private boolean nextSheet() {
        while (this.currentSheet < this.getNumberOfSheets()) {
            Sheet sheet = this.getSheet(this.currentSheet);
            this.rs = this.rowSetFactory.create(sheet);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Opening sheet " + sheet.getName() + "."));
            }
            for (int i = 0; i < this.linesToSkip; ++i) {
                if (!this.rs.next() || this.skippedRowsCallback == null) continue;
                this.skippedRowsCallback.handleRow(this.rs);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Openend sheet " + sheet.getName() + ", with " + sheet.getNumberOfRows() + " rows."));
            }
            ++this.currentSheet;
            if (!this.rs.next()) continue;
            return true;
        }
        return false;
    }

    protected void doClose() throws Exception {
        this.currentSheet = 0;
        this.rs = null;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.rowMapper, (String)"RowMapper must be set");
    }

    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    protected abstract Sheet getSheet(int var1);

    protected abstract int getNumberOfSheets();

    protected abstract void openExcelFile(Resource var1, String var2) throws Exception;

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setRowSetFactory(RowSetFactory rowSetFactory) {
        this.rowSetFactory = rowSetFactory;
    }

    public void setSkippedRowsCallback(RowCallbackHandler skippedRowsCallback) {
        this.skippedRowsCallback = skippedRowsCallback;
    }

    public void setEndAfterBlankLines(int endAfterBlankLines) {
        this.endAfterBlankLines = endAfterBlankLines;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

