/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.util.StringUtils;

final class SimpleClientHttpResponse
extends AbstractClientHttpResponse {
    private static final String AUTHENTICATION_ERROR = "Received authentication challenge is null";
    private final HttpURLConnection connection;
    private HttpHeaders headers;

    SimpleClientHttpResponse(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public int getRawStatusCode() throws IOException {
        return this.connection.getResponseCode();
    }

    @Override
    public HttpStatus getStatusCode() throws IOException {
        try {
            return HttpStatus.valueOf(this.getRawStatusCode());
        }
        catch (IOException ex) {
            if (ex.getLocalizedMessage().equals(AUTHENTICATION_ERROR)) {
                return HttpStatus.UNAUTHORIZED;
            }
            throw ex;
        }
    }

    @Override
    public String getStatusText() throws IOException {
        try {
            return this.connection.getResponseMessage();
        }
        catch (IOException ex) {
            if (ex.getLocalizedMessage().equals(AUTHENTICATION_ERROR)) {
                return HttpStatus.UNAUTHORIZED.getReasonPhrase();
            }
            throw ex;
        }
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            String name = this.connection.getHeaderFieldKey(0);
            if (StringUtils.hasLength((String)name)) {
                this.headers.add(name, this.connection.getHeaderField(0));
            }
            int i = 1;
            while (StringUtils.hasLength((String)(name = this.connection.getHeaderFieldKey(i)))) {
                this.headers.add(name, this.connection.getHeaderField(i));
                ++i;
            }
        }
        return this.headers;
    }

    @Override
    protected InputStream getBodyInternal() throws IOException {
        InputStream errorStream = this.connection.getErrorStream();
        return errorStream != null ? errorStream : this.connection.getInputStream();
    }

    @Override
    protected void closeInternal() {
        this.connection.disconnect();
    }
}

