/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXmlHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private Serializer serializer;

    public SimpleXmlHttpMessageConverter() {
        this((Serializer)new Persister());
    }

    public SimpleXmlHttpMessageConverter(Serializer serializer) {
        super(MediaType.APPLICATION_XML, MediaType.TEXT_XML, MediaType.APPLICATION_WILDCARD_XML);
        this.setSerializer(serializer);
    }

    public void setSerializer(Serializer serializer) {
        Assert.notNull((Object)serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.canRead(mediaType);
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return clazz.isAnnotationPresent(Root.class) && this.canWrite(mediaType);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStreamReader source = new InputStreamReader(inputMessage.getBody(), this.getCharset(inputMessage.getHeaders()));
        try {
            Object result = this.serializer.read(clazz, (Reader)source);
            if (!clazz.isInstance(result)) {
                throw new TypeMismatchException(result, clazz);
            }
            return result;
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("Could not read [" + clazz + "]", ex);
        }
    }

    @Override
    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStreamWriter out = new OutputStreamWriter(outputMessage.getBody(), this.getCharset(outputMessage.getHeaders()));
        try {
            this.serializer.write(o, (Writer)out);
            ((Writer)out).close();
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("Could not write [" + o + "]", ex);
        }
    }

    private Charset getCharset(HttpHeaders headers) {
        if (headers != null && headers.getContentType() != null && headers.getContentType().getCharSet() != null) {
            return headers.getContentType().getCharSet();
        }
        return DEFAULT_CHARSET;
    }
}

