/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.feed;

import android.os.Build;
import com.google.code.rome.android.repackaged.com.sun.syndication.feed.WireFeed;
import com.google.code.rome.android.repackaged.com.sun.syndication.io.FeedException;
import com.google.code.rome.android.repackaged.com.sun.syndication.io.WireFeedInput;
import com.google.code.rome.android.repackaged.com.sun.syndication.io.WireFeedOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWireFeedHttpMessageConverter<T extends WireFeed>
extends AbstractHttpMessageConverter<T> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    protected AbstractWireFeedHttpMessageConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
        if (Build.VERSION.SDK != null && Integer.parseInt(Build.VERSION.SDK) < 8) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    @Override
    protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        WireFeedInput feedInput = new WireFeedInput();
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType != null && contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
        try {
            InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
            return (T)feedInput.build((Reader)reader);
        }
        catch (FeedException ex) {
            throw new HttpMessageNotReadableException("Could not read WireFeed: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void writeInternal(T wireFeed, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType;
        String wireFeedEncoding = wireFeed.getEncoding();
        if (!StringUtils.hasLength((String)wireFeedEncoding)) {
            wireFeedEncoding = DEFAULT_CHARSET.name();
        }
        if ((contentType = outputMessage.getHeaders().getContentType()) != null) {
            Charset wireFeedCharset = Charset.forName(wireFeedEncoding);
            contentType = new MediaType(contentType.getType(), contentType.getSubtype(), wireFeedCharset);
            outputMessage.getHeaders().setContentType(contentType);
        }
        WireFeedOutput feedOutput = new WireFeedOutput();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), wireFeedEncoding);
            feedOutput.output(wireFeed, (Writer)writer);
        }
        catch (FeedException ex) {
            throw new HttpMessageNotWritableException("Could not write WiredFeed: " + ex.getMessage(), ex);
        }
    }
}

