/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;

public class StreamingSimpleClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpURLConnection connection;
    private final int chunkSize;
    private OutputStream body;

    StreamingSimpleClientHttpRequest(HttpURLConnection connection, int chunkSize) {
        this.connection = connection;
        this.chunkSize = chunkSize;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex.getMessage(), ex);
        }
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        if (this.body == null) {
            int contentLength = (int)headers.getContentLength();
            if (contentLength >= 0) {
                this.connection.setFixedLengthStreamingMode(contentLength);
            } else {
                this.connection.setChunkedStreamingMode(this.chunkSize);
            }
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String headerName = entry.getKey();
                for (String headerValue : entry.getValue()) {
                    this.connection.addRequestProperty(headerName, headerValue);
                }
            }
            this.connection.connect();
            this.body = this.connection.getOutputStream();
        }
        return new NonClosingOutputStream(this.body);
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        try {
            if (this.body != null) {
                this.body.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SimpleClientHttpResponse(this.connection);
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        private NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
        }
    }
}

