/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingClientHttpRequest;
import org.springframework.http.client.BufferingClientHttpResponse;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

class BufferingClientHttpRequest
extends AbstractBufferingClientHttpRequest {
    private final ClientHttpRequest request;

    BufferingClientHttpRequest(ClientHttpRequest request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        this.request = request;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        this.request.getHeaders().putAll((Map<? extends String, ? extends List<String>>)((Object)headers));
        OutputStream body = this.request.getBody();
        FileCopyUtils.copy((byte[])bufferedOutput, (OutputStream)body);
        ClientHttpResponse response = this.request.execute();
        return new BufferingClientHttpResponse(response);
    }
}

