/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.ConditionalExceptionLogger;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.backoff.BackOff;

public class ListenerContainerFactoryBean
extends AbstractFactoryBean<AbstractMessageListenerContainer>
implements ApplicationContextAware,
BeanNameAware,
ApplicationEventPublisherAware,
SmartLifecycle {
    private final Map<String, String> micrometerTags = new HashMap<String, String>();
    private @Nullable ApplicationContext applicationContext;
    private @Nullable String beanName;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private Type type = Type.simple;
    private @Nullable AbstractMessageListenerContainer listenerContainer;
    private @Nullable ConnectionFactory connectionFactory;
    private @Nullable Boolean channelTransacted;
    private @Nullable AcknowledgeMode acknowledgeMode;
    private String @Nullable [] queueNames;
    private Queue @Nullable [] queues;
    private @Nullable Boolean exposeListenerChannel;
    private @Nullable MessageListener messageListener;
    private @Nullable ErrorHandler errorHandler;
    private @Nullable Boolean deBatchingEnabled;
    private Advice @Nullable [] adviceChain;
    private MessagePostProcessor @Nullable [] afterReceivePostProcessors;
    private @Nullable Boolean autoStartup;
    private @Nullable Integer phase;
    private @Nullable String listenerId;
    private @Nullable ConsumerTagStrategy consumerTagStrategy;
    private @Nullable Map<String, Object> consumerArgs;
    private @Nullable Boolean noLocal;
    private @Nullable Boolean exclusive;
    private @Nullable Boolean defaultRequeueRejected;
    private @Nullable Integer prefetchCount;
    private @Nullable Boolean globalQos;
    private @Nullable Long shutdownTimeout;
    private @Nullable Long idleEventInterval;
    private @Nullable PlatformTransactionManager transactionManager;
    private @Nullable TransactionAttribute transactionAttribute;
    private @Nullable Executor taskExecutor;
    private @Nullable Long recoveryInterval;
    private @Nullable BackOff recoveryBackOff;
    private @Nullable MessagePropertiesConverter messagePropertiesConverter;
    private @Nullable RabbitAdmin rabbitAdmin;
    private @Nullable Boolean missingQueuesFatal;
    private @Nullable Boolean possibleAuthenticationFailureFatal;
    private @Nullable Boolean mismatchedQueuesFatal;
    private @Nullable Boolean autoDeclare;
    private @Nullable Long failedDeclarationRetryInterval;
    private @Nullable ConditionalExceptionLogger exclusiveConsumerExceptionLogger;
    private @Nullable Integer consumersPerQueue;
    private @Nullable TaskScheduler taskScheduler;
    private @Nullable Long monitorInterval;
    private @Nullable Integer concurrentConsumers;
    private @Nullable Integer maxConcurrentConsumers;
    private @Nullable Long startConsumerMinInterval;
    private @Nullable Long stopConsumerMinInterval;
    private @Nullable Integer consecutiveActiveTrigger;
    private @Nullable Integer consecutiveIdleTrigger;
    private @Nullable Long receiveTimeout;
    private @Nullable Long batchReceiveTimeout;
    private @Nullable Integer batchSize;
    private @Nullable Integer declarationRetries;
    private @Nullable Long retryDeclarationInterval;
    private @Nullable Boolean consumerBatchEnabled;
    private @Nullable Boolean micrometerEnabled;
    private @Nullable ContainerCustomizer<SimpleMessageListenerContainer> smlcCustomizer;
    private @Nullable ContainerCustomizer<DirectMessageListenerContainer> dmlcCustomizer;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setChannelTransacted(boolean transactional) {
        this.channelTransacted = transactional;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setQueueNames(String ... queueName) {
        this.queueNames = queueName;
    }

    public void setQueues(Queue ... queues) {
        this.queues = queues;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setDeBatchingEnabled(boolean deBatchingEnabled) {
        this.deBatchingEnabled = deBatchingEnabled;
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        this.afterReceivePostProcessors = afterReceivePostProcessors;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setListenerId(String listenerId) {
        this.listenerId = listenerId;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    public void setConsumerArguments(Map<String, Object> args) {
        this.consumerArgs = args;
    }

    public void setNoLocal(Boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setDefaultRequeueRejected(boolean defaultRequeueRejected) {
        this.defaultRequeueRejected = defaultRequeueRejected;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setGlobalQos(boolean globalQos) {
        this.globalQos = globalQos;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setIdleEventInterval(long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        this.recoveryBackOff = recoveryBackOff;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    public void setRabbitAdmin(RabbitAdmin rabbitAdmin) {
        this.rabbitAdmin = rabbitAdmin;
    }

    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
    }

    public void setPossibleAuthenticationFailureFatal(Boolean possibleAuthenticationFailureFatal) {
        this.possibleAuthenticationFailureFatal = possibleAuthenticationFailureFatal;
    }

    public void setMismatchedQueuesFatal(boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    public void setAutoDeclare(boolean autoDeclare) {
        this.autoDeclare = autoDeclare;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setExclusiveConsumerExceptionLogger(ConditionalExceptionLogger exclusiveConsumerExceptionLogger) {
        this.exclusiveConsumerExceptionLogger = exclusiveConsumerExceptionLogger;
    }

    public void setConsumersPerQueue(int consumersPerQueue) {
        this.consumersPerQueue = consumersPerQueue;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setMonitorInterval(long monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public void setStartConsumerMinInterval(long startConsumerMinInterval) {
        this.startConsumerMinInterval = startConsumerMinInterval;
    }

    public void setStopConsumerMinInterval(long stopConsumerMinInterval) {
        this.stopConsumerMinInterval = stopConsumerMinInterval;
    }

    public void setConsecutiveActiveTrigger(int consecutiveActiveTrigger) {
        this.consecutiveActiveTrigger = consecutiveActiveTrigger;
    }

    public void setConsecutiveIdleTrigger(int consecutiveIdleTrigger) {
        this.consecutiveIdleTrigger = consecutiveIdleTrigger;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setBatchReceiveTimeout(long batchReceiveTimeout) {
        this.batchReceiveTimeout = batchReceiveTimeout;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setConsumerBatchEnabled(boolean consumerBatchEnabled) {
        this.consumerBatchEnabled = consumerBatchEnabled;
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setMicrometerEnabled(boolean enabled) {
        this.micrometerEnabled = enabled;
    }

    public void setMicrometerTags(Map<String, String> tags) {
        this.micrometerTags.putAll(tags);
    }

    public void setSMLCCustomizer(ContainerCustomizer<SimpleMessageListenerContainer> customizer) {
        this.smlcCustomizer = customizer;
    }

    public void setDMLCCustomizer(ContainerCustomizer<DirectMessageListenerContainer> customizer) {
        this.dmlcCustomizer = customizer;
    }

    public Class<?> getObjectType() {
        return this.listenerContainer == null ? AbstractMessageListenerContainer.class : this.listenerContainer.getClass();
    }

    protected AbstractMessageListenerContainer createInstance() {
        if (this.listenerContainer == null) {
            AbstractMessageListenerContainer container = this.createContainer();
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.applicationContext, container::setApplicationContext).acceptIfNotNull((Object)this.beanName, container::setBeanName).acceptIfNotNull((Object)this.applicationEventPublisher, container::setApplicationEventPublisher).acceptIfNotNull((Object)this.channelTransacted, container::setChannelTransacted).acceptIfNotNull((Object)this.acknowledgeMode, container::setAcknowledgeMode).acceptIfNotNull((Object)this.queueNames, container::setQueueNames).acceptIfNotNull((Object)this.queues, container::setQueues).acceptIfNotNull((Object)this.exposeListenerChannel, container::setExposeListenerChannel).acceptIfNotNull((Object)this.messageListener, container::setMessageListener).acceptIfNotNull((Object)this.errorHandler, container::setErrorHandler).acceptIfNotNull((Object)this.deBatchingEnabled, container::setDeBatchingEnabled).acceptIfNotNull((Object)this.adviceChain, container::setAdviceChain).acceptIfNotNull((Object)this.afterReceivePostProcessors, container::setAfterReceivePostProcessors).acceptIfNotNull((Object)this.autoStartup, container::setAutoStartup).acceptIfNotNull((Object)this.phase, container::setPhase).acceptIfNotNull((Object)this.listenerId, container::setListenerId).acceptIfNotNull((Object)this.consumerTagStrategy, container::setConsumerTagStrategy).acceptIfNotNull(this.consumerArgs, container::setConsumerArguments).acceptIfNotNull((Object)this.noLocal, container::setNoLocal).acceptIfNotNull((Object)this.exclusive, container::setExclusive).acceptIfNotNull((Object)this.defaultRequeueRejected, container::setDefaultRequeueRejected).acceptIfNotNull((Object)this.prefetchCount, container::setPrefetchCount).acceptIfNotNull((Object)this.globalQos, container::setGlobalQos).acceptIfNotNull((Object)this.shutdownTimeout, container::setShutdownTimeout).acceptIfNotNull((Object)this.idleEventInterval, container::setIdleEventInterval).acceptIfNotNull((Object)this.transactionManager, container::setTransactionManager).acceptIfNotNull((Object)this.transactionAttribute, container::setTransactionAttribute).acceptIfNotNull((Object)this.taskExecutor, container::setTaskExecutor).acceptIfNotNull((Object)this.recoveryInterval, container::setRecoveryInterval).acceptIfNotNull((Object)this.recoveryBackOff, container::setRecoveryBackOff).acceptIfNotNull((Object)this.messagePropertiesConverter, container::setMessagePropertiesConverter).acceptIfNotNull((Object)this.rabbitAdmin, container::setAmqpAdmin).acceptIfNotNull((Object)this.missingQueuesFatal, container::setMissingQueuesFatal).acceptIfNotNull((Object)this.possibleAuthenticationFailureFatal, container::setPossibleAuthenticationFailureFatal).acceptIfNotNull((Object)this.mismatchedQueuesFatal, container::setMismatchedQueuesFatal).acceptIfNotNull((Object)this.autoDeclare, container::setAutoDeclare).acceptIfNotNull((Object)this.failedDeclarationRetryInterval, container::setFailedDeclarationRetryInterval).acceptIfNotNull((Object)this.exclusiveConsumerExceptionLogger, container::setExclusiveConsumerExceptionLogger).acceptIfNotNull((Object)this.micrometerEnabled, container::setMicrometerEnabled).acceptIfCondition(!this.micrometerTags.isEmpty(), this.micrometerTags, container::setMicrometerTags);
            if (this.smlcCustomizer != null && this.type.equals((Object)Type.simple)) {
                this.smlcCustomizer.configure((SimpleMessageListenerContainer)container);
            } else if (this.dmlcCustomizer != null && this.type.equals((Object)Type.direct)) {
                this.dmlcCustomizer.configure((DirectMessageListenerContainer)container);
            }
            container.afterPropertiesSet();
            this.listenerContainer = container;
        }
        return this.listenerContainer;
    }

    private AbstractMessageListenerContainer createContainer() {
        Assert.notNull((Object)this.connectionFactory, (String)"'connectionFactory' is required");
        if (this.type.equals((Object)Type.simple)) {
            SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(this.connectionFactory);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.concurrentConsumers, container::setConcurrentConsumers).acceptIfNotNull((Object)this.maxConcurrentConsumers, container::setMaxConcurrentConsumers).acceptIfNotNull((Object)this.startConsumerMinInterval, container::setStartConsumerMinInterval).acceptIfNotNull((Object)this.stopConsumerMinInterval, container::setStopConsumerMinInterval).acceptIfNotNull((Object)this.consecutiveActiveTrigger, container::setConsecutiveActiveTrigger).acceptIfNotNull((Object)this.consecutiveIdleTrigger, container::setConsecutiveIdleTrigger).acceptIfNotNull((Object)this.receiveTimeout, container::setReceiveTimeout).acceptIfNotNull((Object)this.batchReceiveTimeout, container::setBatchReceiveTimeout).acceptIfNotNull((Object)this.batchSize, container::setBatchSize).acceptIfNotNull((Object)this.consumerBatchEnabled, container::setConsumerBatchEnabled).acceptIfNotNull((Object)this.declarationRetries, container::setDeclarationRetries).acceptIfNotNull((Object)this.retryDeclarationInterval, container::setRetryDeclarationInterval);
            return container;
        }
        DirectMessageListenerContainer container = new DirectMessageListenerContainer(this.connectionFactory);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.consumersPerQueue, container::setConsumersPerQueue).acceptIfNotNull((Object)this.taskScheduler, container::setTaskScheduler).acceptIfNotNull((Object)this.monitorInterval, container::setMonitorInterval);
        return container;
    }

    public void start() {
        if (this.listenerContainer != null) {
            this.listenerContainer.start();
        }
    }

    public void stop() {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    public boolean isRunning() {
        return this.listenerContainer != null && this.listenerContainer.isRunning();
    }

    public int getPhase() {
        return this.listenerContainer != null ? this.listenerContainer.getPhase() : 0;
    }

    public boolean isAutoStartup() {
        return this.listenerContainer != null && this.listenerContainer.isAutoStartup();
    }

    public void stop(Runnable callback) {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop(callback);
        } else {
            callback.run();
        }
    }

    public static enum Type {
        simple,
        direct;

    }
}

