/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.ReplyFailureException;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.Assert;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private HandlerAdapter handlerMethod;
    private final MessagingMessageConverterAdapter messagingMessageConverter;
    private final boolean returnExceptions;
    private final RabbitListenerErrorHandler errorHandler;

    public MessagingMessageListenerAdapter() {
        this(null, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, false, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler) {
        this.messagingMessageConverter = new MessagingMessageConverterAdapter(bean, method);
        this.returnExceptions = returnExceptions;
        this.errorHandler = errorHandler;
    }

    public void setHandlerMethod(HandlerAdapter handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    @Override
    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messagingMessageConverter.setPayloadConverter(messageConverter);
    }

    @Override
    public void onMessage(org.springframework.amqp.core.Message amqpMessage, Channel channel) throws Exception {
        Message<?> message = this.toMessagingMessage(amqpMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        try {
            Object result = this.invokeHandler(amqpMessage, channel, message);
            if (result != null) {
                this.handleResult(result, amqpMessage, channel, message);
            } else {
                this.logger.trace((Object)"No result object given - no result to handle");
            }
        }
        catch (ListenerExecutionFailedException e) {
            if (this.errorHandler != null) {
                try {
                    Object result = this.errorHandler.handleError(amqpMessage, message, e);
                    if (result != null) {
                        this.handleResult(result, amqpMessage, channel, message);
                    }
                    this.logger.trace((Object)"Error handler returned no result");
                }
                catch (Exception ex) {
                    this.returnOrThrow(amqpMessage, channel, message, ex, ex);
                }
            }
            this.returnOrThrow(amqpMessage, channel, message, e.getCause(), (Exception)((Object)e));
        }
    }

    private void returnOrThrow(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message, Throwable throwableToReturn, Exception exceptionToThrow) throws Exception {
        if (!this.returnExceptions) {
            throw exceptionToThrow;
        }
        try {
            this.handleResult(new RemoteInvocationResult(throwableToReturn), amqpMessage, channel, message);
        }
        catch (ReplyFailureException rfe) {
            if (Void.TYPE.equals(this.handlerMethod.getReturnType(message.getPayload()))) {
                throw exceptionToThrow;
            }
            throw rfe;
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message)this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    private Object invokeHandler(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) {
        try {
            return this.handlerMethod.invoke(message, amqpMessage, channel);
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex, amqpMessage);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethodAsString(message.getPayload()) + "' threw exception", ex, amqpMessage);
        }
    }

    private String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerMethod.getMethodAsString(payload) + "]\nBean [" + this.handlerMethod.getBean() + "]";
    }

    @Override
    protected org.springframework.amqp.core.Message buildMessage(Channel channel, Object result) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            if (result instanceof Message) {
                return this.messagingMessageConverter.toMessage(result, new MessageProperties());
            }
            return converter.toMessage(result, new MessageProperties());
        }
        if (!(result instanceof org.springframework.amqp.core.Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (org.springframework.amqp.core.Message)result;
    }

    private final class MessagingMessageConverterAdapter
    extends MessagingMessageConverter {
        private final Object bean;
        private final Method method;
        private final Type inferredArgumentType;

        MessagingMessageConverterAdapter(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
            this.inferredArgumentType = this.determineInferredType();
            if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled() && this.inferredArgumentType != null) {
                MessagingMessageListenerAdapter.this.logger.debug((Object)("Inferred argument type for " + method.toString() + " is " + this.inferredArgumentType));
            }
        }

        protected Object extractPayload(org.springframework.amqp.core.Message message) {
            MessageProperties messageProperties = message.getMessageProperties();
            if (this.bean != null) {
                messageProperties.setTargetBean(this.bean);
            }
            if (this.method != null) {
                messageProperties.setTargetMethod(this.method);
                if (this.inferredArgumentType != null) {
                    messageProperties.setInferredArgumentType(this.inferredArgumentType);
                }
            }
            return MessagingMessageListenerAdapter.this.extractMessage(message);
        }

        private Type determineInferredType() {
            if (this.method == null) {
                return null;
            }
            Type genericParameterType = null;
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                MethodParameter methodParameter = new MethodParameter(this.method, i);
                if (!this.isEligibleParameter(methodParameter) || methodParameter.getParameterAnnotations().length != 0 && !methodParameter.hasParameterAnnotation(Payload.class)) continue;
                if (genericParameterType == null) {
                    ParameterizedType parameterizedType;
                    genericParameterType = methodParameter.getGenericParameterType();
                    if (!(genericParameterType instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericParameterType).getRawType().equals(Message.class)) continue;
                    genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                    continue;
                }
                if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled()) {
                    MessagingMessageListenerAdapter.this.logger.debug((Object)("Ambiguous parameters for target payload for method " + this.method + "; no inferred type header added"));
                }
                return null;
            }
            return genericParameterType;
        }

        private boolean isEligibleParameter(MethodParameter methodParameter) {
            ParameterizedType parameterizedType;
            Type parameterType = methodParameter.getGenericParameterType();
            if (parameterType.equals(Channel.class) || parameterType.equals(org.springframework.amqp.core.Message.class)) {
                return false;
            }
            if (parameterType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)parameterType).getRawType().equals(Message.class)) {
                return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
            }
            return !parameterType.equals(Message.class);
        }
    }
}

