/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.support.converter;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.Properties;
import com.rabbitmq.stream.codec.WrapperMessageBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.rabbit.stream.support.StreamMessageProperties;
import org.springframework.rabbit.stream.support.converter.StreamMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultStreamMessageConverter
implements StreamMessageConverter {
    private final Charset charset = StandardCharsets.UTF_8;
    private Supplier<MessageBuilder> builderSupplier;

    public DefaultStreamMessageConverter() {
        this.builderSupplier = WrapperMessageBuilder::new;
    }

    public DefaultStreamMessageConverter(Codec codec) {
        this.builderSupplier = () -> ((Codec)codec).messageBuilder();
    }

    public void setBuilderSupplier(Supplier<MessageBuilder> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    @Override
    public org.springframework.amqp.core.Message toMessage(Object object, StreamMessageProperties messageProperties) throws MessageConversionException {
        Assert.isInstanceOf(Message.class, (Object)object);
        Message streamMessage = (Message)object;
        this.toMessageProperties(streamMessage, messageProperties);
        return org.springframework.amqp.core.MessageBuilder.withBody((byte[])streamMessage.getBodyAsBinary()).andProperties((MessageProperties)messageProperties).build();
    }

    @Override
    public Message fromMessage(org.springframework.amqp.core.Message message) throws MessageConversionException {
        MessageBuilder builder = this.builderSupplier.get();
        MessageBuilder.PropertiesBuilder propsBuilder = builder.properties();
        MessageProperties props = message.getMessageProperties();
        Assert.isInstanceOf(StreamMessageProperties.class, (Object)props);
        StreamMessageProperties mProps = (StreamMessageProperties)props;
        JavaUtils.INSTANCE.acceptIfNotNull((Object)mProps.getMessageId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).messageId(arg_0)).acceptIfNotNull((Object)mProps.getUserId(), usr -> propsBuilder.userId(usr.getBytes(this.charset))).acceptIfNotNull((Object)mProps.getTo(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).to(arg_0)).acceptIfNotNull((Object)mProps.getSubject(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).subject(arg_0)).acceptIfNotNull((Object)mProps.getReplyTo(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).replyTo(arg_0)).acceptIfNotNull((Object)mProps.getCorrelationId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).correlationId(arg_0)).acceptIfNotNull((Object)mProps.getContentType(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).contentType(arg_0)).acceptIfNotNull((Object)mProps.getContentEncoding(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).contentEncoding(arg_0)).acceptIfNotNull((Object)mProps.getCreationTime(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).creationTime(arg_0)).acceptIfNotNull((Object)mProps.getGroupId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).groupId(arg_0)).acceptIfNotNull((Object)mProps.getGroupSequence(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).groupSequence(arg_0)).acceptIfNotNull((Object)mProps.getReplyToGroupId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).replyToGroupId(arg_0));
        MessageBuilder.ApplicationPropertiesBuilder appPropsBuilder = builder.applicationProperties();
        long creationTime = mProps.getCreationTime();
        if (creationTime <= 0L) {
            creationTime = System.currentTimeMillis();
        }
        propsBuilder.creationTime(creationTime);
        String expiration = mProps.getExpiration();
        if (StringUtils.hasText((String)expiration)) {
            propsBuilder.absoluteExpiryTime(creationTime + Long.parseLong(expiration));
        }
        mProps.getHeaders().forEach((key, val) -> this.mapProp((String)key, val, appPropsBuilder));
        builder.addData(message.getBody());
        return builder.build();
    }

    private void mapProp(String key, @Nullable Object val, MessageBuilder.ApplicationPropertiesBuilder builder) {
        if (val instanceof String) {
            String string = (String)val;
            builder.entry(key, string);
        } else if (val instanceof Long) {
            Long longValue = (Long)val;
            builder.entry(key, longValue.longValue());
        } else if (val instanceof Integer) {
            Integer intValue = (Integer)val;
            builder.entry(key, intValue.intValue());
        } else if (val instanceof Short) {
            Short shortValue = (Short)val;
            builder.entry(key, shortValue.shortValue());
        } else if (val instanceof Byte) {
            Byte byteValue = (Byte)val;
            builder.entry(key, byteValue.byteValue());
        } else if (val instanceof Double) {
            Double doubleValue = (Double)val;
            builder.entry(key, doubleValue.doubleValue());
        } else if (val instanceof Float) {
            Float floatValue = (Float)val;
            builder.entry(key, floatValue.floatValue());
        } else if (val instanceof Character) {
            Character character = (Character)val;
            builder.entry(key, character.charValue());
        } else if (val instanceof UUID) {
            UUID uuid = (UUID)val;
            builder.entry(key, uuid);
        } else if (val instanceof byte[]) {
            byte[] bytes = (byte[])val;
            builder.entry(key, bytes);
        }
    }

    private void toMessageProperties(Message streamMessage, StreamMessageProperties mProps) {
        Map applicationProperties;
        Properties properties = streamMessage.getProperties();
        if (properties != null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)properties.getMessageIdAsString(), arg_0 -> ((StreamMessageProperties)mProps).setMessageId(arg_0)).acceptIfNotNull((Object)properties.getUserId(), usr -> mProps.setUserId(new String((byte[])usr, this.charset))).acceptIfNotNull((Object)properties.getTo(), mProps::setTo).acceptIfNotNull((Object)properties.getSubject(), mProps::setSubject).acceptIfNotNull((Object)properties.getReplyTo(), arg_0 -> ((StreamMessageProperties)mProps).setReplyTo(arg_0)).acceptIfNotNull((Object)properties.getCorrelationIdAsString(), arg_0 -> ((StreamMessageProperties)mProps).setCorrelationId(arg_0)).acceptIfNotNull((Object)properties.getContentType(), arg_0 -> ((StreamMessageProperties)mProps).setContentType(arg_0)).acceptIfNotNull((Object)properties.getContentEncoding(), arg_0 -> ((StreamMessageProperties)mProps).setContentEncoding(arg_0)).acceptIfNotNull((Object)properties.getGroupId(), mProps::setGroupId).acceptIfNotNull((Object)properties.getGroupSequence(), mProps::setGroupSequence).acceptIfNotNull((Object)properties.getReplyToGroupId(), mProps::setReplyToGroupId);
            long creationTime = properties.getCreationTime();
            if (creationTime <= 0L) {
                creationTime = System.currentTimeMillis();
            }
            mProps.setCreationTime(creationTime);
            long absoluteExpiryTime = properties.getAbsoluteExpiryTime();
            if (absoluteExpiryTime > creationTime) {
                mProps.setExpiration(Long.toString(absoluteExpiryTime - creationTime));
            }
        }
        if ((applicationProperties = streamMessage.getApplicationProperties()) != null) {
            mProps.getHeaders().putAll(applicationProperties);
        }
    }
}

