/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.pdf.layout;

import java.util.Arrays;
import org.springframework.ai.reader.pdf.layout.Character;

class TextLine {
    private static final char SPACE_CHARACTER = ' ';
    private final int lineLength;
    private final char[] line;
    private int lastIndex;

    TextLine(int lineLength) {
        if (lineLength < 0) {
            throw new IllegalArgumentException("Line length cannot be negative");
        }
        this.lineLength = lineLength / 4;
        this.line = new char[this.lineLength];
        Arrays.fill(this.line, ' ');
    }

    public void writeCharacterAtIndex(Character character) {
        character.setIndex(this.computeIndexForCharacter(character));
        int index = character.getIndex();
        char characterValue = character.getCharacterValue();
        if (this.indexIsInBounds(index) && this.line[index] == ' ') {
            this.line[index] = characterValue;
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public String getLine() {
        return new String(this.line);
    }

    private int computeIndexForCharacter(Character character) {
        int index = character.getIndex();
        boolean isCharacterPartOfPreviousWord = character.isCharacterPartOfPreviousWord();
        boolean isCharacterAtTheBeginningOfNewLine = character.isCharacterAtTheBeginningOfNewLine();
        boolean isCharacterCloseToPreviousWord = character.isCharacterCloseToPreviousWord();
        if (!this.indexIsInBounds(index)) {
            return -1;
        }
        if (isCharacterPartOfPreviousWord && !isCharacterAtTheBeginningOfNewLine) {
            index = this.findMinimumIndexWithSpaceCharacterFromIndex(index);
        } else if (isCharacterCloseToPreviousWord) {
            index = this.line[index] != ' ' ? ++index : this.findMinimumIndexWithSpaceCharacterFromIndex(index) + 1;
        }
        index = this.getNextValidIndex(index, isCharacterPartOfPreviousWord);
        return index;
    }

    private boolean isNotSpaceCharacterAtIndex(int index) {
        return this.line[index] != ' ';
    }

    private boolean isNewIndexGreaterThanLastIndex(int index) {
        return index > this.lastIndex;
    }

    private int getNextValidIndex(int index, boolean isCharacterPartOfPreviousWord) {
        int nextValidIndex = index;
        if (!this.isNewIndexGreaterThanLastIndex(index)) {
            nextValidIndex = this.lastIndex + 1;
        }
        if (!isCharacterPartOfPreviousWord && index > 0 && this.isNotSpaceCharacterAtIndex(index - 1)) {
            ++nextValidIndex;
        }
        this.lastIndex = nextValidIndex;
        return nextValidIndex;
    }

    private int findMinimumIndexWithSpaceCharacterFromIndex(int index) {
        int newIndex;
        for (newIndex = index; newIndex >= 0 && this.line[newIndex] == ' '; --newIndex) {
        }
        return newIndex + 1;
    }

    private boolean indexIsInBounds(int index) {
        return index >= 0 && index < this.lineLength;
    }
}

